/*
 * Decompiled with CFR 0.152.
 */
package com.jz.jar.franchise.repository;

import com.alibaba.fastjson.JSON;
import com.jz.common.utils.collection.ArrayMapTools;
import com.jz.jar.franchise.repository.FranchiseBaseRepository;
import com.jz.jar.franchise.wrapper.CaseChildWrapper;
import com.jz.jooq.franchise.Tables;
import com.jz.jooq.franchise.tables.MarketCaseCommunicateRecord;
import com.jz.jooq.franchise.tables.pojos.MarketCasePool;
import java.util.List;
import org.jooq.Condition;
import org.jooq.Field;
import org.jooq.Table;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Repository;

@Lazy
@Repository
public class MarketCasePoolRepository
extends FranchiseBaseRepository {
    private static final com.jz.jooq.franchise.tables.MarketCasePool MCP = Tables.MARKET_CASE_POOL;
    private static final MarketCaseCommunicateRecord MCCR = Tables.MARKET_CASE_COMMUNICATE_RECORD;

    public MarketCasePool getMarketCaseById(String caseId, String schoolId) {
        return (MarketCasePool)this.franchiseCtx.selectFrom((Table)MCP).where(new Condition[]{MarketCasePoolRepository.MCP.ID.eq((Object)caseId).and(MarketCasePoolRepository.MCP.SCHOOL_ID.eq((Object)schoolId))}).fetchAnyInto(MarketCasePool.class);
    }

    public MarketCasePool getMarketCaseByPhone(String schoolId, String phone) {
        return (MarketCasePool)this.franchiseCtx.selectFrom((Table)MCP).where(new Condition[]{MarketCasePoolRepository.MCP.SCHOOL_ID.eq((Object)schoolId).and(MarketCasePoolRepository.MCP.PHONE.eq((Object)phone))}).fetchAnyInto(MarketCasePool.class);
    }

    public MarketCasePool getMarketCaseByPuid(String schoolId, String puid) {
        return (MarketCasePool)this.franchiseCtx.selectFrom((Table)MCP).where(new Condition[]{MarketCasePoolRepository.MCP.SCHOOL_ID.eq((Object)schoolId).and(MarketCasePoolRepository.MCP.PUID.eq((Object)puid))}).fetchAnyInto(MarketCasePool.class);
    }

    public void createCase(String caseId, String uid, String schoolId, String channelId, String phone, String wechat, String qq, List<CaseChildWrapper> childs, String childPy, String parentName, String relation, String address, String district, String level, long nextCommunicateTime) {
        long timeMillis = System.currentTimeMillis();
        this.franchiseCtx.insertInto((Table)MCP, (Field)MarketCasePoolRepository.MCP.ID, (Field)MarketCasePoolRepository.MCP.SCHOOL_ID, (Field)MarketCasePoolRepository.MCP.PHONE, (Field)MarketCasePoolRepository.MCP.WECHAT, (Field)MarketCasePoolRepository.MCP.QQ, (Field)MarketCasePoolRepository.MCP.PARENT_NAME, (Field)MarketCasePoolRepository.MCP.CHILD_INFO, (Field)MarketCasePoolRepository.MCP.CHILD_PY, (Field)MarketCasePoolRepository.MCP.RELATION, (Field)MarketCasePoolRepository.MCP.ADDRESS, (Field)MarketCasePoolRepository.MCP.DISTRICT, (Field)MarketCasePoolRepository.MCP.LEVEL, (Field)MarketCasePoolRepository.MCP.CHANNEL_ID, (Field)MarketCasePoolRepository.MCP.CREATED, (Field)MarketCasePoolRepository.MCP.LAST_CREATED, (Field)MarketCasePoolRepository.MCP.CREATE_USER, (Field)MarketCasePoolRepository.MCP.NEXT_COMMUNICATE_TIME).values((Object)caseId, (Object)schoolId, (Object)phone, (Object)wechat, (Object)qq, (Object)parentName, (Object)(ArrayMapTools.isNotEmpty(childs) ? JSON.toJSONString(childs) : ""), (Object)childPy, (Object)relation, (Object)address, (Object)district, (Object)level, (Object)channelId, (Object)timeMillis, (Object)timeMillis, (Object)uid, (Object)nextCommunicateTime).execute();
    }

    public void updateLastCreatedAndCreateNumForCurrent(String caseId) {
        this.franchiseCtx.update((Table)MCP).set((Field)MarketCasePoolRepository.MCP.LAST_CREATED, (Object)System.currentTimeMillis()).set((Field)MarketCasePoolRepository.MCP.CREATE_NUM, MarketCasePoolRepository.MCP.CREATE_NUM.add((Number)1)).where(new Condition[]{MarketCasePoolRepository.MCP.ID.eq((Object)caseId)}).execute();
    }

    public void updateCaseLevel(String schoolId, String caseId, String level) {
        this.franchiseCtx.update((Table)MCP).set((Field)MarketCasePoolRepository.MCP.LEVEL, (Object)level).where(new Condition[]{MarketCasePoolRepository.MCP.ID.eq((Object)caseId)}).and(MarketCasePoolRepository.MCP.SCHOOL_ID.eq((Object)schoolId)).execute();
    }

    public void createCommunicateRecord(String schoolId, String caseId, String uid, String operRecord, String communicateRs, String level, int effect) {
        this.franchiseCtx.insertInto((Table)MCCR, (Field)MarketCasePoolRepository.MCCR.SCHOOL_ID, (Field)MarketCasePoolRepository.MCCR.CASE_ID, (Field)MarketCasePoolRepository.MCCR.UID, (Field)MarketCasePoolRepository.MCCR.OPER_RECORD, (Field)MarketCasePoolRepository.MCCR.COMMUNICATE_RS, (Field)MarketCasePoolRepository.MCCR.LEVEL, (Field)MarketCasePoolRepository.MCCR.EFFECT, (Field)MarketCasePoolRepository.MCCR.CREATED).values((Object)schoolId, (Object)caseId, (Object)uid, (Object)operRecord, (Object)communicateRs, (Object)level, (Object)effect, (Object)System.currentTimeMillis()).execute();
    }

    public int cntCaseNumByAdviser(String schoolId, String adviser) {
        return this.franchiseCtx.fetchCount((Table)MCP, MarketCasePoolRepository.MCP.SCHOOL_ID.eq((Object)schoolId).and(MarketCasePoolRepository.MCP.ADVISER.eq((Object)adviser)).and(MarketCasePoolRepository.MCP.HIDDEN.eq((Object)0)));
    }
}

