/*
 * Decompiled with CFR 0.152.
 */
package com.jz.jar.franchise.service;

import com.jz.common.utils.collection.ArrayMapTools;
import com.jz.jar.franchise.repository.ParentInfoRepository;
import com.jz.jar.franchise.wrapper.ParentWrapper;
import com.jz.jooq.franchise.tables.pojos.ParentInfo;
import java.util.Collection;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@Lazy
@Service
public class ParentInfoService {
    @Autowired
    private ParentInfoRepository parentInfoRepository;

    public void savePatentInfo(String puid, String phone, String relation, int appLogin) {
        this.parentInfoRepository.savePatentInfo(puid, phone, relation, appLogin);
    }

    public ParentInfo getParentInfoForPhone(String phone) {
        return this.parentInfoRepository.getParentInfoForPhone(phone);
    }

    public void updateAppLogin(String phone) {
        this.parentInfoRepository.updateAppLogin(phone);
    }

    public void updateAddressForUid(String puid, String address) {
        this.parentInfoRepository.updateAddressForUid(puid, address);
    }

    public ParentInfo getParentInfoForId(String uid) {
        return this.parentInfoRepository.getParentInfoForId(uid);
    }

    public ParentWrapper getParentWrapper(String puid) {
        ParentInfo pi = this.getParentInfoForId(puid);
        return pi != null ? ParentWrapper.of(pi) : null;
    }

    public ParentInfo getSimpleParentInfo(String puid) {
        return this.parentInfoRepository.getSimpleParentInfo(puid);
    }

    public List<ParentInfo> getSimpleParentInfo(Collection<String> puids) {
        return this.parentInfoRepository.getSimpleParentInfo(puids);
    }

    public List<ParentInfo> mutiGetParentInfo(Collection<String> puids) {
        return this.parentInfoRepository.mutiGetParentInfo(puids);
    }

    public boolean allExistUser(String ... uids) {
        if (ArrayMapTools.isEmpty((String[])uids)) {
            return false;
        }
        return this.parentInfoRepository.countExistUid(uids) == uids.length;
    }

    public void updateUserInfo(String puid, String name, String avatar) {
        this.parentInfoRepository.updateUserInfo(puid, name, avatar);
    }

    public void updateRelation(String puid, String relation) {
        this.parentInfoRepository.updateRelation(puid, relation);
    }

    public void updatePhoneForWriteOff(String puid, String phone) {
        this.parentInfoRepository.updatePhoneForWriteOff(puid, phone);
    }
}

