/*
 * Decompiled with CFR 0.152.
 */
package com.jz.jar.franchise.service;

import com.jz.jar.franchise.repository.MarketCasePoolRepository;
import com.jz.jar.franchise.wrapper.CaseChildWrapper;
import com.jz.jooq.franchise.tables.pojos.MarketCasePool;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@Lazy
@Service
public class MarketCasePoolService {
    @Autowired
    private MarketCasePoolRepository marketCasePoolRepository;

    public MarketCasePool getMarketCaseById(String caseId, String schoolId) {
        return this.marketCasePoolRepository.getMarketCaseById(caseId, schoolId);
    }

    public MarketCasePool getMarketCaseByPhone(String schoolId, String phone) {
        return this.marketCasePoolRepository.getMarketCaseByPhone(schoolId, phone);
    }

    public MarketCasePool getMarketCaseByPuid(String schoolId, String puid) {
        return this.marketCasePoolRepository.getMarketCaseByPuid(schoolId, puid);
    }

    public void createCase(String caseId, String uid, String schoolId, String channelId, String phone, String wechat, String qq, List<CaseChildWrapper> childs, String childPy, String parentName, String relation, String address, String district, String level, long nextCommunicateTime) {
        this.marketCasePoolRepository.createCase(caseId, uid, schoolId, channelId, phone, wechat, qq, childs, childPy, parentName, relation, address, district, level, nextCommunicateTime);
    }

    public void joinAuditionForOldCase(MarketCasePool mcp, String channelId) {
        String schoolId = mcp.getSchoolId();
        this.marketCasePoolRepository.updateLastCreatedAndCreateNumForCurrent(mcp.getId());
        if (!StringUtils.equals((CharSequence)mcp.getChannelId(), (CharSequence)channelId)) {
            this.marketCasePoolRepository.createCommunicateRecord(schoolId, mcp.getId(), "", "\u8be5\u6f5c\u5ba2\u9884\u7ea6\u4e86\u8bd5\u542c\uff0c\u8bf7\u5c3d\u5feb\u6c9f\u901a", "", "", 0);
        }
        if (StringUtils.equals((CharSequence)mcp.getLevel(), (CharSequence)"D")) {
            this.marketCasePoolRepository.updateCaseLevel(schoolId, mcp.getId(), "Z");
        }
    }
}

