/*
 * Decompiled with CFR 0.152.
 */
package com.jz.jar.franchise.service;

import com.google.common.collect.Maps;
import com.jz.jar.franchise.repository.LessonDakaRepository;
import com.jz.jar.franchise.repository.LessonStudentDakaRepository;
import com.jz.jooq.franchise.tables.pojos.LessonDaka;
import com.jz.jooq.franchise.tables.pojos.LessonStudentDaka;
import com.jz.jooq.franchise.tables.records.LessonStudentDakaRecord;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@Lazy
@Service
public class LessonDakaService {
    @Autowired
    private LessonDakaRepository lessonDakaRepository;
    @Autowired
    private LessonStudentDakaRepository lessonStudentDakaRepository;

    public LessonDaka getDakaByLessonId(String schoolId, String lessonId) {
        return this.lessonDakaRepository.getDakaByLessonId(schoolId, lessonId);
    }

    public Map<String, LessonDaka> mutiGetSchoolLessonId2Daka(Map<String, Collection<String>> schoolId2LessonIds) {
        List<LessonDaka> list = this.lessonDakaRepository.mutiGetDakaBySchoolIdsLessonIds(schoolId2LessonIds);
        HashMap lessonId2Daka = Maps.newHashMap();
        for (LessonDaka d : list) {
            lessonId2Daka.put(d.getLessonId(), d);
        }
        return lessonId2Daka;
    }

    public void createStudentDaka(LessonStudentDakaRecord record) {
        this.lessonStudentDakaRepository.createStudentDaka(record);
    }

    public void updateStudentDaka(LessonStudentDakaRecord record) {
        this.lessonStudentDakaRepository.updateStudentDaka(record);
    }

    public LessonStudentDaka getStudentDaka(String schoolId, String lessonId, String suid) {
        return this.lessonStudentDakaRepository.getStudentDaka(schoolId, lessonId, suid);
    }

    public List<LessonStudentDaka> getStudentDakaListByLessonId(String schoolId, String lessonId) {
        return this.lessonStudentDakaRepository.getStudentDakaListByLessonId(schoolId, lessonId);
    }

    public Map<String, LessonStudentDaka> mutiGetStudentLessonId2Daka(String suid, Map<String, Collection<String>> schoolId2LessonIds) {
        List<LessonStudentDaka> list = this.lessonStudentDakaRepository.mutiGetStudentDakaBySchoolIdsLessonIds(suid, schoolId2LessonIds);
        HashMap lessonId2Daka = Maps.newHashMap();
        for (LessonStudentDaka d : list) {
            lessonId2Daka.put(d.getLessonId(), d);
        }
        return lessonId2Daka;
    }
}

