/*
 * Decompiled with CFR 0.152.
 */
package com.jz.jar.franchise.repository;

import com.jz.jar.franchise.repository.FranchiseBaseRepository;
import com.jz.jooq.franchise.Tables;
import com.jz.jooq.franchise.tables.PaperCertOrder;
import com.jz.jooq.franchise.tables.records.PaperCertOrderRecord;
import java.math.BigDecimal;
import java.util.List;
import org.jooq.Condition;
import org.jooq.Field;
import org.jooq.Table;
import org.jooq.TableRecord;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Repository;

@Lazy
@Repository
public class PaperCertRepository
extends FranchiseBaseRepository {
    private static final PaperCertOrder PCO = Tables.PAPER_CERT_ORDER;

    public void createOrder(PaperCertOrderRecord record) {
        this.franchiseCtx.batchInsert(new TableRecord[]{record}).execute();
    }

    public void finishPay(String orderId, BigDecimal payMoney, String paymentMode, String onlineTradeId) {
        this.franchiseCtx.update((Table)PCO).set((Field)PaperCertRepository.PCO.PAY_MONEY, (Object)payMoney).set((Field)PaperCertRepository.PCO.PAYMENT_MODE, (Object)paymentMode).set((Field)PaperCertRepository.PCO.ONLINE_PAY_TRADE_ID, (Object)onlineTradeId).set((Field)PaperCertRepository.PCO.STATUS, (Object)1).set((Field)PaperCertRepository.PCO.PAY_TIME, (Object)System.currentTimeMillis()).where(new Condition[]{PaperCertRepository.PCO.ID.eq((Object)orderId)}).execute();
    }

    public com.jz.jooq.franchise.tables.pojos.PaperCertOrder getOrder(String orderId) {
        return (com.jz.jooq.franchise.tables.pojos.PaperCertOrder)this.franchiseCtx.selectFrom((Table)PCO).where(new Condition[]{PaperCertRepository.PCO.ID.eq((Object)orderId)}).fetchAnyInto(com.jz.jooq.franchise.tables.pojos.PaperCertOrder.class);
    }

    public int cntUserOrderPage(String puid, boolean needAll) {
        return this.franchiseCtx.fetchCount((Table)PCO, this.genUserOrderPageWhere(puid, needAll));
    }

    public List<com.jz.jooq.franchise.tables.pojos.PaperCertOrder> getOrderPage(String puid, boolean needAll, int start, int size) {
        return this.franchiseCtx.selectFrom((Table)PCO).where(new Condition[]{this.genUserOrderPageWhere(puid, needAll)}).orderBy(PaperCertRepository.PCO.CREATE_TIME.desc(), PaperCertRepository.PCO.ID.asc()).limit(start, size).fetchInto(com.jz.jooq.franchise.tables.pojos.PaperCertOrder.class);
    }

    private Condition genUserOrderPageWhere(String puid, boolean needAll) {
        Condition c = PaperCertRepository.PCO.PUID.eq((Object)puid);
        c = needAll ? c.and(PaperCertRepository.PCO.STATUS.ge((Object)1)) : c.and(PaperCertRepository.PCO.STATUS.eq((Object)1));
        return c;
    }

    public void applyRefund(String id, int status, String refundReason, String refundOperator) {
        this.franchiseCtx.update((Table)PCO).set((Field)PaperCertRepository.PCO.STATUS, (Object)status).set((Field)PaperCertRepository.PCO.REFUND_REASON, (Object)refundReason).set((Field)PaperCertRepository.PCO.REFUND_APPLY_TIME, (Object)System.currentTimeMillis()).set((Field)PaperCertRepository.PCO.REFUND_OPERATOR, (Object)refundOperator).where(new Condition[]{PaperCertRepository.PCO.ID.eq((Object)id)}).execute();
    }
}

