package com.jz.jar.franchise.repository;

import java.util.Collection;
import java.util.List;

import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Repository;

import com.jz.jooq.franchise.Tables;
import com.jz.jooq.franchise.tables.pojos.CoursePackSchool;
import com.jz.jooq.franchise.tables.pojos.CoursePackSchoolDetail;
import com.jz.jooq.franchise.tables.pojos.CoursePackV2;
import com.jz.jooq.franchise.tables.pojos.CoursePackV2HoSchool;
import com.jz.jooq.franchise.tables.pojos.CoursePackV2Detail;

/**
 * @author 连杰
 */
@Lazy
@Repository
public class CoursePackRepository extends FranchiseBaseRepository {

	private static final com.jz.jooq.franchise.tables.CoursePackV2 CPV2 = Tables.COURSE_PACK_V2;
	private static final com.jz.jooq.franchise.tables.CoursePackV2Detail CPDV2 = Tables.COURSE_PACK_V2_DETAIL;
	private static final com.jz.jooq.franchise.tables.CoursePackV2HoSchool CPCV2 = Tables.COURSE_PACK_V2_HO_SCHOOL;

	private static final com.jz.jooq.franchise.tables.CoursePackSchool CPS = Tables.COURSE_PACK_SCHOOL;
	private static final com.jz.jooq.franchise.tables.CoursePackSchoolDetail CPSD = Tables.COURSE_PACK_SCHOOL_DETAIL;

	public List<CoursePackV2Detail> getHoDetails(String brandId, Collection<String> coursePackIds) {
		return franchiseCtx.selectFrom(CPDV2).where(CPDV2.COURSE_PACK_ID.in(coursePackIds))
				.fetchInto(CoursePackV2Detail.class);
	}

	public List<Integer> getHoCourseIds(String brandId, String coursePackId) {
		return franchiseCtx.select(CPDV2.COURSE_ID).from(CPDV2)
				.where(CPDV2.BRAND_ID.eq(brandId).and(CPDV2.COURSE_PACK_ID.eq(coursePackId))).fetchInto(Integer.class);
	}

	public List<CoursePackSchoolDetail> getSchoolDetail(String schoolId, Collection<String> coursePackIds) {
		return franchiseCtx.selectFrom(CPSD)
				.where(CPSD.SCHOOL_ID.eq(schoolId).and(CPSD.COURSE_PACK_ID.in(coursePackIds)))
				.fetchInto(CoursePackSchoolDetail.class);
	}

	public List<Integer> getSchoolCourseIds(String schoolId, String coursePackId) {
		return franchiseCtx.select(CPSD.COURSE_ID).from(CPSD)
				.where(CPSD.SCHOOL_ID.eq(schoolId).and(CPSD.COURSE_PACK_ID.eq(coursePackId))).fetchInto(Integer.class);
	}

	public List<CoursePackV2> mutiGetEnableCoursePackHoOrder(String brandId, Collection<String> coursePackIds) {
		return franchiseCtx.selectFrom(CPV2)
				.where(CPV2.BRAND_ID.eq(brandId).and(CPV2.COURSE_PACK_ID.in(coursePackIds)).and(CPV2.ENABLE.eq(1)))
				.orderBy(CPV2.CREATE_TIME.asc()).fetchInto(CoursePackV2.class);
	}

	public List<CoursePackV2> mutiGetCoursePackHo(String brandId, Collection<String> coursePackIds) {
		return franchiseCtx.selectFrom(CPV2)
				.where(CPV2.BRAND_ID.eq(brandId).and(CPV2.COURSE_PACK_ID.in(coursePackIds)))
				.fetchInto(CoursePackV2.class);
	}

	public List<CoursePackSchool> mutiGetPackSchool(String schoolId, Collection<String> coursePackIds) {
		return franchiseCtx.selectFrom(CPS).where(CPS.SCHOOL_ID.eq(schoolId).and(CPS.COURSE_PACK_ID.in(coursePackIds)))
				.fetchInto(CoursePackSchool.class);
	}

	public List<CoursePackSchool> mutiGetPackSchool(Collection<String> schoolIds, Collection<String> coursePackIds) {
		return franchiseCtx.selectFrom(CPS)
				.where(CPS.SCHOOL_ID.in(schoolIds).and(CPS.COURSE_PACK_ID.in(coursePackIds)))
				.fetchInto(CoursePackSchool.class);
	}

	public CoursePackV2 getCoursePackHo(String brandId, String coursePackId) {
		return franchiseCtx.selectFrom(CPV2).where(CPV2.BRAND_ID.eq(brandId).and(CPV2.COURSE_PACK_ID.eq(coursePackId)))
				.fetchAnyInto(CoursePackV2.class);
	}

	public CoursePackV2HoSchool getCoursePackCity(String schoolId, String coursePackId) {
		return franchiseCtx.selectFrom(CPCV2)
				.where(CPCV2.SCHOOL_ID.eq(schoolId).and(CPCV2.COURSE_PACK_ID.eq(coursePackId)))
				.fetchAnyInto(CoursePackV2HoSchool.class);
	}

	public CoursePackSchool getCoursePackSchool(String schoolId, String coursePackId) {
		return franchiseCtx.selectFrom(CPS).where(CPS.SCHOOL_ID.eq(schoolId).and(CPS.COURSE_PACK_ID.eq(coursePackId)))
				.fetchAnyInto(CoursePackSchool.class);
	}

	public List<String> getHoPackIdsByCourseId(String brandId, int courseId) {
		return franchiseCtx.select(CPDV2.COURSE_PACK_ID).from(CPDV2)
				.where(CPDV2.BRAND_ID.eq(brandId).and(CPDV2.COURSE_ID.eq(courseId))).fetchInto(String.class);
	}

	public List<String> getSchoolPackIdsByCourseId(String schoolId, int courseId) {
		return franchiseCtx.select(CPSD.COURSE_PACK_ID).from(CPSD)
				.where(CPSD.SCHOOL_ID.eq(schoolId).and(CPSD.COURSE_ID.eq(courseId))).fetchInto(String.class);
	}

}
