package com.jz.jar.franchise.cache;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;

import redis.clients.jedis.JedisCluster;

/**
 * @author 连杰
 */
@Lazy
@Component
public class FranchiseTokenKeyCache {

	private Logger logger = LoggerFactory.getLogger(FranchiseTokenKeyCache.class);

	private static int expireTime = 36000; // 10个小时

	@Autowired
	private JedisCluster jedisCluster;

	private String genRedisKey(String uid) {
		return "tokenKey:{" + uid + "}";
	}

	public String getPwdPart(String uid) {
		try {
			String key = this.genRedisKey(uid);
			return jedisCluster.get(key);
		} catch (Exception e) {
			logger.error(e.getMessage(), e);
			return null;
		}
	}

	public void setPwdPart(String uid, String pwdPart) {
		try {
			String key = this.genRedisKey(uid);
			jedisCluster.set(key, pwdPart);
			jedisCluster.expire(key, expireTime);
		} catch (Exception e) {
			logger.error(e.getMessage(), e);
		}
	}

	public void delPwdPart(String uid) {
		try {
			String key = this.genRedisKey(uid);
			jedisCluster.del(key);
		} catch (Exception e) {
			logger.error(e.getMessage(), e);
		}
	}

}
