package com.jz.jar.franchise.repository;

import java.util.Collection;
import java.util.List;
import java.util.Map;

import org.jooq.Condition;
import org.jooq.impl.DSL;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Repository;

import com.jz.common.utils.collection.ArrayMapTools;
import com.jz.jooq.franchise.Tables;
import com.jz.jooq.franchise.tables.pojos.ClassStudent;
import com.jz.jooq.franchise.tables.records.ClassStudentRecord;

@Lazy
@Repository
public class ClassStudentRepository extends FranchiseBaseRepository implements FranchiseConditionRepository<ClassStudentRecord> {

	private static final com.jz.jooq.franchise.tables.ClassStudent CS = Tables.CLASS_STUDENT;

	public List<ClassStudent> findClassStudent(String suid, Map<String, Collection<String>> school2ClassId) {
		Condition condition = getOrWhereCondition(CS.SCHOOL_ID, CS.CID, school2ClassId).and(CS.SUID.eq(suid));
		return franchiseCtx.selectFrom(CS).where(condition)
				.fetchInto(ClassStudent.class);
	}

	public String getContract(String suid, String school, String classId) {
		Condition condition = CS.SCHOOL_ID.eq(school).and(CS.CID.eq(classId)).and(CS.SUID.eq(suid));
		// 不存在时间 || 结束时间 > 当前时间,则是有效的合同
		condition = condition.and(DSL.or(CS.END_TIME.isNull(), CS.END_TIME.gt(System.currentTimeMillis())));
		List<String> list = franchiseCtx.select(CS.CONTRACT_ID).from(CS).where(condition).fetchInto(String.class);
		return ArrayMapTools.isNotEmpty(list) ? list.get(0) : null;
	}
}
