/*
 * Decompiled with CFR 0.152.
 */
package com.jz.jar.franchise.repository;

import com.google.common.collect.Lists;
import com.jz.common.utils.collection.ArrayMapTools;
import com.jz.jar.franchise.repository.FranchiseBaseRepository;
import com.jz.jar.franchise.repository.FranchiseConditionRepository;
import com.jz.jooq.franchise.Tables;
import com.jz.jooq.franchise.tables.ClassInfo;
import com.jz.jooq.franchise.tables.records.ClassInfoRecord;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.jooq.Condition;
import org.jooq.Table;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Repository;

@Lazy
@Repository
public class ClassRepository
extends FranchiseBaseRepository
implements FranchiseConditionRepository<ClassInfoRecord> {
    private static final ClassInfo CI = Tables.CLASS_INFO;

    public List<com.jz.jooq.franchise.tables.pojos.ClassInfo> mutiGetClassInfo(Map<String, Collection<String>> school2Cid) {
        if (ArrayMapTools.isEmpty(school2Cid)) {
            return Lists.newArrayList();
        }
        Condition condition = this.getOrWhereCondition(ClassRepository.CI.SCHOOL_ID, ClassRepository.CI.CID, school2Cid);
        return this.franchiseCtx.selectFrom((Table)CI).where(new Condition[]{condition}).fetchInto(com.jz.jooq.franchise.tables.pojos.ClassInfo.class);
    }

    public com.jz.jooq.franchise.tables.pojos.ClassInfo getClassInfo(String schoolId, String cid) {
        return (com.jz.jooq.franchise.tables.pojos.ClassInfo)this.franchiseCtx.selectFrom((Table)CI).where(new Condition[]{ClassRepository.CI.SCHOOL_ID.eq((Object)schoolId).and(ClassRepository.CI.CID.eq((Object)cid))}).fetchAnyInto(com.jz.jooq.franchise.tables.pojos.ClassInfo.class);
    }
}

