/*
 * Decompiled with CFR 0.152.
 */
package com.jz.jar.franchise.cache;

import com.google.common.collect.Lists;
import com.jz.common.utils.collection.ArrayMapTools;
import com.jz.common.utils.json.GsonTools;
import com.jz.common.utils.text.StringTools;
import com.jz.jooq.franchise.tables.pojos.Lesson;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;
import redis.clients.jedis.JedisCluster;

@Lazy
@Component
public class LessonCache {
    private static final Logger logger = LoggerFactory.getLogger(LessonCache.class);
    private static final int seconds = 600;
    @Autowired
    private JedisCluster jedisCluster;

    private String key(Lesson lesson) {
        return this.key(lesson.getSchoolId(), lesson.getLessonId());
    }

    private String key(String school, String lesson) {
        return new StringBuffer().append("school2Lesson:").append(school).append(":").append(lesson).toString();
    }

    public void setLesson(Lesson lesson) {
        if (null == lesson) {
            return;
        }
        try {
            this.jedisCluster.set(this.key(lesson), GsonTools.gson.toJson((Object)lesson), "nx", "ex", 600L);
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    public void setLesson(List<Lesson> lessons) {
        if (ArrayMapTools.isEmpty(lessons)) {
            return;
        }
        try {
            lessons.forEach(it -> this.jedisCluster.set(this.key((Lesson)it), GsonTools.gson.toJson(it), "nx", "ex", 600L));
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    public Lesson getLesson(String school, String lesson) {
        if (!StringTools.allNotEmptyAndBlank((String[])new String[]{school, lesson})) {
            return null;
        }
        try {
            String gson = this.jedisCluster.get(this.key(school, lesson));
            if (StringTools.isEmptyAndBlank((String)gson)) {
                return null;
            }
            return (Lesson)GsonTools.gson.fromJson(gson, Lesson.class);
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public List<Lesson> getLesson(Map<String, Collection<String>> school2Lessons) {
        if (ArrayMapTools.isEmpty(school2Lessons)) {
            return null;
        }
        try {
            ArrayList result = Lists.newArrayList();
            school2Lessons.forEach((schoolId, lessons) -> lessons.forEach(lid -> {
                String gson = this.jedisCluster.get(this.key((String)schoolId, (String)lid));
                if (StringTools.isNotEmptyAndBlank((String)gson)) {
                    result.add(GsonTools.gson.fromJson(gson, Lesson.class));
                }
            }));
            return result;
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }
}

