package com.jz.jar.franchise.service;

import java.math.BigDecimal;
import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

import com.jz.jar.franchise.repository.PaperCertRepository;
import com.jz.jooq.franchise.tables.pojos.PaperCertOrder;
import com.jz.jooq.franchise.tables.records.PaperCertOrderRecord;

@Lazy
@Service
public class PaperCertService {

	@Autowired
	private PaperCertRepository paperCertRepository;

	public void createOrder(PaperCertOrderRecord record) {
		paperCertRepository.createOrder(record);
	}

	public void finishPay(String orderId, BigDecimal payMoney, String paymentMode, String onlineTradeId) {
		paperCertRepository.finishPay(orderId, payMoney, paymentMode, onlineTradeId);
	}

	public PaperCertOrder getOrder(String orderId) {
		return paperCertRepository.getOrder(orderId);
	}

	public int cntUserOrderPage(String puid, boolean needAll) {
		return paperCertRepository.cntUserOrderPage(puid, needAll);
	}

	public List<PaperCertOrder> getOrderPage(String puid, boolean needAll, int start, int size) {
		return paperCertRepository.getOrderPage(puid, needAll, start, size);
	}

	public void applyRefund(String id, int status, String refundReason, String refundOperator) {
		paperCertRepository.applyRefund(id, status, refundReason, refundOperator);
	}
}
