package com.jz.jar.franchise.repository;

import org.apache.commons.lang3.StringUtils;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Repository;

import com.jz.jooq.franchise.Tables;
import com.jz.jooq.franchise.tables.pojos.TomatoChangeNewCourseTime;

@Lazy
@Repository
public class TomatoChangeCourseRepository extends FranchiseBaseRepository {

	private static final com.jz.jooq.franchise.tables.TomatoChangeNewCourseTime TC = Tables.TOMATO_CHANGE_NEW_COURSE_TIME;

	public int calContractVer(String brandId, String schoolId) {
		if (!StringUtils.equals(brandId, "tomato")) {
			return 0;
		}
		TomatoChangeNewCourseTime tc = franchiseCtx.selectFrom(TC).where(TC.SCHOOL_ID.eq(schoolId))
				.fetchAnyInto(TomatoChangeNewCourseTime.class);
		if (tc == null) {
			return 0;
		}
		return System.currentTimeMillis() > tc.getChangeTime() ? 1 : 0;
	}

}
