package com.jz.jar.franchise.repository;

import java.util.Collection;
import java.util.Map;

import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Repository;

import com.jz.jooq.franchise.Tables;
import com.jz.jooq.franchise.tables.pojos.CourseTomatoPlanGuideVideo;

@Lazy
@Repository
public class CourseTomatoGuideVideoRepository extends FranchiseBaseRepository {

	private static final com.jz.jooq.franchise.tables.CourseTomatoPlanGuideVideo CTPGV = Tables.COURSE_TOMATO_PLAN_GUIDE_VIDEO;

	public Map<String, String> mutiGetPlanId2Wid(Collection<String> planIds) {
		return franchiseCtx.select(CTPGV.PLAN_ID, CTPGV.WID).from(CTPGV)
				.where(CTPGV.PLAN_ID.in(planIds).and(CTPGV.STATUS.eq(1))).groupBy(CTPGV.PLAN_ID)
				.fetchMap(CTPGV.PLAN_ID, CTPGV.WID);
	}

	public CourseTomatoPlanGuideVideo getGuideVideo(String wid) {
		return franchiseCtx.selectFrom(CTPGV).where(CTPGV.WID.eq(wid)).fetchAnyInto(CourseTomatoPlanGuideVideo.class);
	}

}
