/*
 * Decompiled with CFR 0.152.
 */
package com.jz.jar.franchise.repository;

import com.jz.jar.franchise.repository.FranchiseBaseRepository;
import com.jz.jooq.franchise.Tables;
import com.jz.jooq.franchise.tables.ActivityArtAward;
import com.jz.jooq.franchise.tables.ActivityArtOtherAuthor;
import com.jz.jooq.franchise.tables.ActivityArtThanks;
import com.jz.jooq.franchise.tables.ActivityOciTeam;
import com.jz.jooq.franchise.tables.ActivityOciTeamMember;
import com.jz.jooq.franchise.tables.pojos.ActivityArt;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.jooq.Condition;
import org.jooq.Field;
import org.jooq.SelectField;
import org.jooq.Table;
import org.jooq.TableLike;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Repository;

@Lazy
@Repository
public class ActivityArtRepository
extends FranchiseBaseRepository {
    private static final com.jz.jooq.franchise.tables.ActivityArt AA = Tables.ACTIVITY_ART;
    private static final ActivityArtAward AAA = Tables.ACTIVITY_ART_AWARD;
    private static final ActivityArtOtherAuthor AAOA = Tables.ACTIVITY_ART_OTHER_AUTHOR;
    private static final ActivityArtThanks AAT = Tables.ACTIVITY_ART_THANKS;
    private static final ActivityOciTeamMember AOTM = Tables.ACTIVITY_OCI_TEAM_MEMBER;
    private static final ActivityOciTeam AOT = Tables.ACTIVITY_OCI_TEAM;

    public List<ActivityArt> getAllSimpleMatchArtBySuid(String suid) {
        return this.franchiseCtx.select((SelectField)ActivityArtRepository.AA.ID, (SelectField)ActivityArtRepository.AA.ACTIVITY_ID, (SelectField)ActivityArtRepository.AA.SUID).from((TableLike)AA).where(new Condition[]{ActivityArtRepository.AA.SUID.eq((Object)suid).and(ActivityArtRepository.AA.STATUS.eq((Object)1)).and(ActivityArtRepository.AA.IS_MATCH.eq((Object)1))}).fetchInto(ActivityArt.class);
    }

    public List<ActivityArt> getAllSimpleMatchArtBySuids(Collection<String> suids) {
        return this.franchiseCtx.select((SelectField)ActivityArtRepository.AA.ID, (SelectField)ActivityArtRepository.AA.ACTIVITY_ID, (SelectField)ActivityArtRepository.AA.SUID).from((TableLike)AA).where(new Condition[]{ActivityArtRepository.AA.SUID.in(suids).and(ActivityArtRepository.AA.STATUS.eq((Object)1)).and(ActivityArtRepository.AA.IS_MATCH.eq((Object)1))}).fetchInto(ActivityArt.class);
    }

    public List<ActivityArt> getAllMatchArtBySuids(Collection<String> suids) {
        return this.franchiseCtx.selectFrom((Table)AA).where(new Condition[]{ActivityArtRepository.AA.SUID.in(suids).and(ActivityArtRepository.AA.STATUS.eq((Object)1)).and(ActivityArtRepository.AA.IS_MATCH.eq((Object)1))}).orderBy(ActivityArtRepository.AA.CREATE_TIME.desc()).fetchInto(ActivityArt.class);
    }

    public ActivityArt getOnlineArtByArtId(String id) {
        return (ActivityArt)this.franchiseCtx.selectFrom((Table)AA).where(new Condition[]{ActivityArtRepository.AA.ID.eq((Object)id).and(ActivityArtRepository.AA.STATUS.eq((Object)1))}).fetchAnyInto(ActivityArt.class);
    }

    public List<ActivityArt> mutiGetOnlineMatchArtByArtIds(Collection<String> artIds) {
        return this.franchiseCtx.selectFrom((Table)AA).where(new Condition[]{ActivityArtRepository.AA.ID.in(artIds).and(ActivityArtRepository.AA.STATUS.eq((Object)1)).and(ActivityArtRepository.AA.IS_MATCH.eq((Object)1))}).fetchInto(ActivityArt.class);
    }

    public List<com.jz.jooq.franchise.tables.pojos.ActivityArtAward> getArtAwardsByArtIds(Collection<String> artIds) {
        return this.franchiseCtx.selectFrom((Table)AAA).where(new Condition[]{ActivityArtRepository.AAA.ART_ID.in(artIds).and(ActivityArtRepository.AAA.STATUS.eq((Object)1))}).fetchInto(com.jz.jooq.franchise.tables.pojos.ActivityArtAward.class);
    }

    public com.jz.jooq.franchise.tables.pojos.ActivityArtAward getArtAwardsByArtId(String artId) {
        return (com.jz.jooq.franchise.tables.pojos.ActivityArtAward)this.franchiseCtx.selectFrom((Table)AAA).where(new Condition[]{ActivityArtRepository.AAA.ART_ID.eq((Object)artId).and(ActivityArtRepository.AAA.STATUS.eq((Object)1))}).fetchAnyInto(com.jz.jooq.franchise.tables.pojos.ActivityArtAward.class);
    }

    public List<com.jz.jooq.franchise.tables.pojos.ActivityArtOtherAuthor> getOtherAuthorBySuid(String suid) {
        return this.franchiseCtx.selectFrom((Table)AAOA).where(new Condition[]{ActivityArtRepository.AAOA.SUID.eq((Object)suid)}).fetchInto(com.jz.jooq.franchise.tables.pojos.ActivityArtOtherAuthor.class);
    }

    public List<com.jz.jooq.franchise.tables.pojos.ActivityArtOtherAuthor> getOtherAuthorBySuids(Collection<String> suids) {
        return this.franchiseCtx.selectFrom((Table)AAOA).where(new Condition[]{ActivityArtRepository.AAOA.SUID.in(suids)}).fetchInto(com.jz.jooq.franchise.tables.pojos.ActivityArtOtherAuthor.class);
    }

    public List<String> getOtherAuthorArtIdsBySuids(Collection<String> suids) {
        return this.franchiseCtx.select((SelectField)ActivityArtRepository.AAOA.ART_ID).from((TableLike)AAOA).where(new Condition[]{ActivityArtRepository.AAOA.SUID.in(suids)}).fetchInto(String.class);
    }

    public List<com.jz.jooq.franchise.tables.pojos.ActivityArtThanks> getArtThanksBySuid(String suid) {
        return this.franchiseCtx.selectFrom((Table)AAT).where(new Condition[]{ActivityArtRepository.AAT.SUID.eq((Object)suid)}).fetchInto(com.jz.jooq.franchise.tables.pojos.ActivityArtThanks.class);
    }

    public List<com.jz.jooq.franchise.tables.pojos.ActivityArtThanks> getArtThanksBySuids(Collection<String> suids) {
        return this.franchiseCtx.selectFrom((Table)AAT).where(new Condition[]{ActivityArtRepository.AAT.SUID.in(suids)}).fetchInto(com.jz.jooq.franchise.tables.pojos.ActivityArtThanks.class);
    }

    public List<com.jz.jooq.franchise.tables.pojos.ActivityOciTeamMember> getOciTeamMembersBySuid(String suid) {
        return this.franchiseCtx.selectFrom((Table)AOTM).where(new Condition[]{ActivityArtRepository.AOTM.SUID.eq((Object)suid).and(ActivityArtRepository.AOTM.STATUS.eq((Object)1))}).fetchInto(com.jz.jooq.franchise.tables.pojos.ActivityOciTeamMember.class);
    }

    public List<com.jz.jooq.franchise.tables.pojos.ActivityOciTeamMember> getOciTeamMembersBySuids(Collection<String> suids) {
        return this.franchiseCtx.selectFrom((Table)AOTM).where(new Condition[]{ActivityArtRepository.AOTM.SUID.in(suids).and(ActivityArtRepository.AOTM.STATUS.eq((Object)1))}).fetchInto(com.jz.jooq.franchise.tables.pojos.ActivityOciTeamMember.class);
    }

    public Map<String, String> mutiGetOciTeamId2CertNameMap(Collection<String> teamIds) {
        return this.franchiseCtx.select((SelectField)ActivityArtRepository.AOT.ID, (SelectField)ActivityArtRepository.AOT.CERT_NAME).from((TableLike)AOT).where(new Condition[]{ActivityArtRepository.AOT.ID.in(teamIds)}).fetchMap((Field)ActivityArtRepository.AOT.ID, (Field)ActivityArtRepository.AOT.CERT_NAME);
    }

    public String getOciCertNameByTeamId(String teamId) {
        return (String)this.franchiseCtx.select((SelectField)ActivityArtRepository.AOT.CERT_NAME).from((TableLike)AOT).where(new Condition[]{ActivityArtRepository.AOT.ID.eq((Object)teamId)}).fetchAnyInto(String.class);
    }
}

