package com.jz.jar.franchise.repository;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;

import org.jooq.Condition;
import org.jooq.TableField;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Repository;

import com.jz.common.utils.collection.ArrayMapTools;
import com.jz.jooq.franchise.Tables;
import com.jz.jooq.franchise.tables.pojos.LessonStudent;
import com.jz.jooq.franchise.tables.records.LessonStudentRecord;

@Lazy
@Repository
public class LessonStudentRepository extends FranchiseBaseRepository {

	private static final com.jz.jooq.franchise.tables.LessonStudent LS = Tables.LESSON_STUDENT;

	private static List<TableField<LessonStudentRecord, ?>> simpleFields;

	static {
		simpleFields = Arrays.asList(LS.SCHOOL_ID, LS.BRAND_ID, LS.LESSON_ID, LS.STATUS, LS.TYPE, LS.CONTRACT_ID,
				LS.EXTRA_ID, LS.NEED_CONSUME_JSON);
	}

	public List<LessonStudent> findSimpleInfo(String suid, String brandId, Collection<Integer> statuses) {
		Condition condition = LS.SUID.eq(suid).and(LS.BRAND_ID.eq(brandId));
		if (ArrayMapTools.isNotEmpty(statuses))
			condition = condition.and(LS.STATUS.in(statuses));
		return franchiseCtx.select(simpleFields).from(LS).where(condition).fetchInto(LessonStudent.class);
	}

	public LessonStudent getSimpleLessonStudent(String schoolId, String lessonId, String suid) {
		return franchiseCtx.select(simpleFields).from(LS)
				.where(LS.SCHOOL_ID.eq(schoolId).and(LS.LESSON_ID.eq(lessonId)).and(LS.SUID.eq(suid)))
				.fetchAnyInto(LessonStudent.class);
	}

	public LessonStudent getLessonStudent(String schoolId, String lessonId, String suid) {
		return franchiseCtx.selectFrom(LS)
				.where(LS.SCHOOL_ID.eq(schoolId).and(LS.LESSON_ID.eq(lessonId)).and(LS.SUID.eq(suid)))
				.fetchAnyInto(LessonStudent.class);
	}

	public void updateStatus(String schoolId, String lessonId, String suid, int status) {
		franchiseCtx.update(LS).set(LS.STATUS, status)
				.where(LS.SCHOOL_ID.eq(schoolId).and(LS.LESSON_ID.eq(lessonId)).and(LS.SUID.eq(suid))).execute();
	}

	public void updateContractStatus(String schoolId, String lessonId, String suid, String contractId, Integer extraId,
			String needConsumeJson, int status) {
		franchiseCtx.update(LS).set(LS.STATUS, status).set(LS.CONTRACT_ID, contractId).set(LS.EXTRA_ID, extraId)
				.set(LS.NEED_CONSUME_JSON, needConsumeJson)
				.where(LS.SCHOOL_ID.eq(schoolId).and(LS.LESSON_ID.eq(lessonId)).and(LS.SUID.eq(suid))).execute();
	}

	public List<LessonStudent> findSimpleFinishedLessonInfo(String suid, String brandId) {
		return franchiseCtx.select(simpleFields).from(LS)
				.where(LS.SUID.eq(suid).and(LS.BRAND_ID.eq(brandId)).and(LS.TYPE.eq(1)).and(LS.STATUS.in(1, 2, 4)))
				.fetchInto(LessonStudent.class);
	}

	public List<LessonStudent> getWaitSignLessonIdSchoolId(String suid, String brandId) {
		return franchiseCtx.select(LS.SCHOOL_ID, LS.LESSON_ID).from(LS)
				.where(LS.SUID.eq(suid).and(LS.BRAND_ID.eq(brandId)).and(LS.STATUS.eq(0)))
				.fetchInto(LessonStudent.class);
	}

	public List<LessonStudent> getAllLessonsBySuid(String suid, String brand) {
		return franchiseCtx.select(LS.SCHOOL_ID, LS.LESSON_ID).from(LS)
				.where(LS.SUID.eq(suid).and(LS.BRAND_ID.eq(brand)).and(LS.STATUS.ne(0))).fetchInto(LessonStudent.class);
	}
}
