/*
 * Decompiled with CFR 0.152.
 */
package com.jz.jar.franchise.repository;

import com.jz.jar.franchise.enums.ContractParentSignStatus;
import com.jz.jar.franchise.repository.FranchiseBaseRepository;
import com.jz.jooq.franchise.Tables;
import com.jz.jooq.franchise.tables.Contract;
import com.jz.jooq.franchise.tables.ContractDetail;
import com.jz.jooq.franchise.tables.ContractParentSign;
import java.util.Collection;
import java.util.List;
import org.jooq.Condition;
import org.jooq.GroupField;
import org.jooq.SelectField;
import org.jooq.Table;
import org.jooq.TableLike;
import org.jooq.impl.DSL;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Repository;

@Lazy
@Repository
public class ContractRepository
extends FranchiseBaseRepository {
    private static final Contract C = Tables.CONTRACT;
    private static final ContractDetail CD = Tables.CONTRACT_DETAIL;
    private static final ContractParentSign CPS = Tables.CONTRACT_PARENT_SIGN;

    public com.jz.jooq.franchise.tables.pojos.Contract getContract(String contractId, String schoolId) {
        return (com.jz.jooq.franchise.tables.pojos.Contract)this.franchiseCtx.selectFrom((Table)C).where(new Condition[]{ContractRepository.C.CONTRACT_ID.eq((Object)contractId).and(ContractRepository.C.SCHOOL_ID.eq((Object)schoolId))}).fetchAnyInto(com.jz.jooq.franchise.tables.pojos.Contract.class);
    }

    public com.jz.jooq.franchise.tables.pojos.Contract getContractForBranch(String brandId, String contractId) {
        return (com.jz.jooq.franchise.tables.pojos.Contract)this.franchiseCtx.selectFrom((Table)C).where(new Condition[]{ContractRepository.C.CONTRACT_ID.eq((Object)contractId).and(ContractRepository.C.BRAND_ID.eq((Object)brandId))}).fetchAnyInto(com.jz.jooq.franchise.tables.pojos.Contract.class);
    }

    public com.jz.jooq.franchise.tables.pojos.ContractDetail getContractDetail(String contractId, String schoolId) {
        return (com.jz.jooq.franchise.tables.pojos.ContractDetail)this.franchiseCtx.selectFrom((Table)CD).where(new Condition[]{ContractRepository.CD.CONTRACT_ID.eq((Object)contractId).and(ContractRepository.CD.SCHOOL_ID.eq((Object)schoolId))}).fetchAnyInto(com.jz.jooq.franchise.tables.pojos.ContractDetail.class);
    }

    public List<com.jz.jooq.franchise.tables.pojos.ContractDetail> mutiGetContractGiftCompany(Collection<String> contractIds) {
        return this.franchiseCtx.select((SelectField)ContractRepository.CD.CONTRACT_ID, (SelectField)ContractRepository.CD.GIFT_NAME, (SelectField)ContractRepository.CD.COMPANY_ID).from((TableLike)CD).where(new Condition[]{ContractRepository.CD.CONTRACT_ID.in(contractIds)}).fetchInto(com.jz.jooq.franchise.tables.pojos.ContractDetail.class);
    }

    public List<com.jz.jooq.franchise.tables.pojos.Contract> getUserContractList(String brandId, String puid) {
        return this.franchiseCtx.selectFrom((Table)C).where(new Condition[]{ContractRepository.C.PUID.eq((Object)puid).and(ContractRepository.C.STATUS.gt((Object)0)).and(ContractRepository.C.BRAND_ID.eq((Object)brandId))}).orderBy(ContractRepository.C.CREATED.desc()).fetchInto(com.jz.jooq.franchise.tables.pojos.Contract.class);
    }

    public List<com.jz.jooq.franchise.tables.pojos.Contract> getPayedContractList(String brandId, String puid) {
        return this.franchiseCtx.selectFrom((Table)C).where(new Condition[]{ContractRepository.C.PUID.eq((Object)puid).and(ContractRepository.C.STATUS.eq((Object)1)).and(ContractRepository.C.BRAND_ID.eq((Object)brandId))}).orderBy(ContractRepository.C.PAY_TIME.desc()).fetchInto(com.jz.jooq.franchise.tables.pojos.Contract.class);
    }

    public boolean isHaveContract(String brandId, String puid) {
        return this.franchiseCtx.fetchExists((Table)C, this.getContractCondition(brandId, puid));
    }

    public boolean isHaveContractInSchool(String schoolId, String puid) {
        return this.franchiseCtx.fetchExists((Table)C, ContractRepository.C.SCHOOL_ID.eq((Object)schoolId).and(ContractRepository.C.PUID.eq((Object)puid)).and(DSL.or((Condition[])new Condition[]{ContractRepository.C.STATUS.in((Object[])new Integer[]{1, 50}), ContractRepository.C.STATUS.ge((Object)20).and(ContractRepository.C.STATUS.le((Object)39))})));
    }

    public List<String> getContractedSchoolIds(String brandId, String puid) {
        return this.franchiseCtx.select((SelectField)ContractRepository.C.SCHOOL_ID).from((TableLike)C).where(new Condition[]{this.getContractCondition(brandId, puid)}).groupBy(new GroupField[]{ContractRepository.C.SCHOOL_ID}).fetchInto(String.class);
    }

    private Condition getContractCondition(String brandId, String puid) {
        Condition condition = ContractRepository.C.PUID.eq((Object)puid).and(ContractRepository.C.BRAND_ID.eq((Object)brandId));
        condition = condition.and(DSL.or((Condition[])new Condition[]{ContractRepository.C.STATUS.in((Object[])new Integer[]{1, 50}), ContractRepository.C.STATUS.ge((Object)20).and(ContractRepository.C.STATUS.le((Object)39))}));
        return condition;
    }

    public boolean isOwnedContract(String branchId, String puid) {
        return this.franchiseCtx.fetchExists((Table)C, ContractRepository.C.PUID.eq((Object)puid).and(ContractRepository.C.BRAND_ID.eq((Object)branchId)));
    }

    public com.jz.jooq.franchise.tables.pojos.Contract getSimpleContract(String contractId) {
        return (com.jz.jooq.franchise.tables.pojos.Contract)this.franchiseCtx.select((SelectField)ContractRepository.C.START_TIME).from((TableLike)C).where(new Condition[]{ContractRepository.C.CONTRACT_ID.eq((Object)contractId)}).fetchAnyInto(com.jz.jooq.franchise.tables.pojos.Contract.class);
    }

    public String getParentSignContent(String contractId) {
        return (String)this.franchiseCtx.select((SelectField)ContractRepository.CPS.CONTENT).from((TableLike)CPS).where(new Condition[]{ContractRepository.CPS.CONTRACT_ID.eq((Object)contractId)}).fetchAnyInto(String.class);
    }

    public int cntWaitParentSignForAppOpen(String brandId, String puid) {
        return this.franchiseCtx.fetchCount((Table)C, ContractRepository.C.PUID.eq((Object)puid).and(ContractRepository.C.STATUS.in((Object[])new Integer[]{10, 12, 14, 16, 18})).and(ContractRepository.C.BRAND_ID.eq((Object)brandId)).and(ContractRepository.C.PARENT_SIGN_STATUS.eq((Object)ContractParentSignStatus.waitSignAffect.code)));
    }

    public List<String> getSchoolIds(String brandId, String puid) {
        return this.franchiseCtx.select((SelectField)ContractRepository.C.SCHOOL_ID).from((TableLike)C).where(new Condition[]{ContractRepository.C.PUID.eq((Object)puid).and(ContractRepository.C.BRAND_ID.eq((Object)brandId))}).fetchInto(String.class);
    }

    public boolean checkIsHaveContractAllBrand(String puid) {
        return this.franchiseCtx.fetchExists((Table)C, ContractRepository.C.PUID.eq((Object)puid));
    }

    public String getContractedSchoolId(String brandId, String puid) {
        return (String)this.franchiseCtx.select((SelectField)ContractRepository.C.SCHOOL_ID).from((TableLike)C).where(new Condition[]{this.getContractCondition(brandId, puid)}).orderBy(ContractRepository.C.CREATED.desc()).limit(1).fetchAnyInto(String.class);
    }

    public String getSuidRecentSchoolId(Collection<String> allContractIds, String brand) {
        return (String)this.franchiseCtx.select((SelectField)ContractRepository.C.SCHOOL_ID).from((TableLike)C).where(new Condition[]{ContractRepository.C.CONTRACT_ID.in(allContractIds).and(ContractRepository.C.BRAND_ID.eq((Object)brand)).and(ContractRepository.C.PAY_TIME.isNotNull())}).orderBy(ContractRepository.C.CREATED.desc()).limit(1).fetchAnyInto(String.class);
    }
}

