package com.jz.jar.franchise.wrapper;

import com.jz.jooq.franchise.tables.pojos.FuserInfo;

public class UserPhoneWrapper extends UserSimpleWrapper {

	private String phone;
	private String position;

	public static UserPhoneWrapper of(String uid, String name, String phone) {
		UserPhoneWrapper wrapper = new UserPhoneWrapper();
		wrapper.setUid(uid).setName(name);
		wrapper.setPhone(phone);
		return wrapper;

	}

	public static UserPhoneWrapper of(FuserInfo userInfo) {
		UserPhoneWrapper wrapper = new UserPhoneWrapper();
		wrapper.setUid(userInfo.getUid()).setName(userInfo.getEnglishName());
		wrapper.setPhone(userInfo.getPhone());
		return wrapper;
	}

	public static UserPhoneWrapper ofChiEng(FuserInfo userInfo) {
		UserPhoneWrapper wrapper = new UserPhoneWrapper();
		wrapper.setUid(userInfo.getUid()).setName(userInfo.getChineseName() + " " + userInfo.getEnglishName());
		wrapper.setPhone(userInfo.getPhone());
		return wrapper;
	}

	public String getPhone() {
		return phone;
	}

	public UserPhoneWrapper setPhone(String phone) {
		this.phone = phone;
		return this;
	}

	public String getPosition() {
		return position;
	}

	public UserPhoneWrapper setPosition(String position) {
		this.position = position;
		return this;
	}

}
