package com.jz.jar.franchise.service;

import java.util.Collection;
import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

import com.jz.jar.franchise.repository.LessonStudentSatisfyRepository;
import com.jz.jooq.franchise.tables.pojos.LessonStudentSatisfy;

@Lazy
@Service
public class LessonStudentSatisfyService {

	@Autowired
	private LessonStudentSatisfyRepository lessonStudentSatisfyRepository;

	public void insUpdate(String schoolId, String lessonId, String suid, int roomLevel, String roomRemark,
			int techLevel, String techRemark, String content) {
		lessonStudentSatisfyRepository.insUpdate(schoolId, lessonId, suid, roomLevel, roomRemark, techLevel,
				techRemark, content);
	}

	public LessonStudentSatisfy getBySchoolLessonSuid(String schoolId, String lessonId, String suid) {
		return lessonStudentSatisfyRepository.getBySchoolLessonSuid(schoolId, lessonId, suid);
	}

	public List<LessonStudentSatisfy> getBySuidLessonIds(String suid, Collection<String> lessonIds) {
		return lessonStudentSatisfyRepository.getBySuidLessonIds(suid, lessonIds);
	}

	public List<String> getMadeLessonIds(String suid, Collection<String> lessonIds) {
		return lessonStudentSatisfyRepository.getMadeLessonIds(suid, lessonIds);
	}
}
