package com.jz.jar.franchise.repository;

import java.util.Collection;
import java.util.List;

import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Repository;

import com.jz.jooq.franchise.Tables;

@Lazy
@Repository
public class StudentSchoolLevelRepository extends FranchiseBaseRepository {

	private static final com.jz.jooq.franchise.tables.StudentSchoolLevel SSL = Tables.STUDENT_SCHOOL_LEVEL;

	public List<Integer> getCourseIdsBySchoolIds(String suid, Collection<String> schoolIds) {
		return franchiseCtx.select(SSL.COURSE_ID).from(SSL).where(SSL.SUID.eq(suid).and(SSL.SCHOOL_ID.in(schoolIds)))
				.groupBy(SSL.COURSE_ID).fetchInto(Integer.class);
	}

}
