package com.jz.jar.franchise.repository;

import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Repository;

import com.jz.jooq.franchise.Tables;

@Lazy
@Repository
public class RegionRepository extends FranchiseBaseRepository {

	private static final com.jz.jooq.franchise.tables.Region R = Tables.REGION;

	public void updateFocs(String uid, String taker) {
		franchiseCtx.update(R).set(R.FOC, taker).where(R.FOC.eq(uid)).execute();
		franchiseCtx.update(R).set(R.FOA, taker).where(R.FOA.eq(uid)).execute();
		franchiseCtx.update(R).set(R.FM, taker).where(R.FM.eq(uid)).execute();
		franchiseCtx.update(R).set(R.FIN_DIRECT, taker).where(R.FIN_DIRECT.eq(uid)).execute();
		franchiseCtx.update(R).set(R.FIN_FRANCHISE, taker).where(R.FIN_FRANCHISE.eq(uid)).execute();
	}

}
