/*
 * Decompiled with CFR 0.152.
 */
package com.jz.jar.franchise.service;

import com.jz.common.utils.security.EncryptionTools;
import com.jz.jar.franchise.cache.FranchiseTokenKeyCache;
import com.jz.jar.franchise.repository.FUserInfoRepository;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@Lazy
@Service
public class FranchiseTokenCalService {
    private Logger logger = LoggerFactory.getLogger(FranchiseTokenCalService.class);
    @Autowired
    private FranchiseTokenKeyCache tokenKeyCache;
    @Autowired
    private FUserInfoRepository fUserInfoRepository;

    public boolean checkTokenIlle(String uid, String token) {
        if (StringUtils.isEmpty((CharSequence)uid)) {
            return false;
        }
        if (StringUtils.isEmpty((CharSequence)token)) {
            return false;
        }
        String[] parts = StringUtils.split((String)token, (String)"_");
        if (parts.length != 2) {
            return false;
        }
        long endTime = Long.parseLong(parts[1]);
        String oldToken = parts[0];
        if (endTime < System.currentTimeMillis()) {
            return false;
        }
        String calToken = this.calToken(uid, endTime);
        return StringUtils.equals((CharSequence)calToken, (CharSequence)oldToken);
    }

    public String getNewToken(String uid) {
        int hours = 72;
        long endTime = System.currentTimeMillis() + (long)(hours * 3600) * 1000L;
        return this.calToken(uid, endTime) + "_" + endTime;
    }

    private String calToken(String uid, long endTime) {
        String str = this.getKey(uid) + "jz" + endTime;
        return EncryptionTools.MD5((String)str, (boolean)false);
    }

    private String getKey(String uid) {
        String pwdPart = this.tokenKeyCache.getPwdPart(uid);
        if (StringUtils.isNotEmpty((CharSequence)pwdPart)) {
            return pwdPart;
        }
        String pwd = this.fUserInfoRepository.getUserPwd(uid);
        if (pwd == null) {
            this.logger.warn("dirty uid:" + uid);
            return StringUtils.substring((String)uid, (int)(uid.length() / 2), (int)uid.length());
        }
        pwdPart = StringUtils.substring((String)pwd, (int)(pwd.length() - 6), (int)pwd.length());
        this.tokenKeyCache.setPwdPart(uid, pwdPart);
        return pwdPart;
    }

    public void cleanCache(String uid) {
        this.tokenKeyCache.delPwdPart(uid);
    }
}

