/*
 * Decompiled with CFR 0.152.
 */
package com.jz.jar.franchise.service;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.jz.common.utils.collection.ArrayMapTools;
import com.jz.jar.franchise.enums.ContractParentSignStatus;
import com.jz.jar.franchise.repository.ContractPostponeRepository;
import com.jz.jar.franchise.repository.ContractRepository;
import com.jz.jar.franchise.repository.ContractTermsRepository;
import com.jz.jar.franchise.repository.StudentInfoRepository;
import com.jz.jar.franchise.repository.StudentSchoolContractRepository;
import com.jz.jar.franchise.service.ContractCompanyService;
import com.jz.jar.franchise.service.CoursePackService;
import com.jz.jar.franchise.service.CourseService;
import com.jz.jar.franchise.service.FUserInfoService;
import com.jz.jar.franchise.service.ParentInfoService;
import com.jz.jar.franchise.wrapper.ContractPostponeWrapper;
import com.jz.jar.franchise.wrapper.ContractStudentWrapper;
import com.jz.jar.franchise.wrapper.ContractWrapper;
import com.jz.jar.franchise.wrapper.CourseWrapper;
import com.jz.jar.franchise.wrapper.SchoolWrapper;
import com.jz.jar.franchise.wrapper.UserSimpleWrapper;
import com.jz.jooq.franchise.tables.pojos.Contract;
import com.jz.jooq.franchise.tables.pojos.ContractCompany;
import com.jz.jooq.franchise.tables.pojos.ContractDetail;
import com.jz.jooq.franchise.tables.pojos.ContractPostpone;
import com.jz.jooq.franchise.tables.pojos.School;
import com.jz.jooq.franchise.tables.pojos.StudentInfo;
import com.jz.jooq.franchise.tables.pojos.StudentSchoolContract;
import com.jz.jooq.franchise.tables.pojos.StudentSchoolExtra;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@Lazy
@Service
public class ContractService {
    private Logger logger = LoggerFactory.getLogger(ContractService.class);
    @Autowired
    private ContractRepository contractRepository;
    @Autowired
    private StudentSchoolContractRepository studentSchoolContractRepository;
    @Autowired
    private FUserInfoService fUserInfoService;
    @Autowired
    private CourseService courseService;
    @Autowired
    private CoursePackService coursePackService;
    @Autowired
    private ParentInfoService parentInfoService;
    @Autowired
    private StudentInfoRepository studentInfoRepository;
    @Autowired
    private ContractPostponeRepository contractPostponeRepository;
    @Autowired
    private ContractTermsRepository contractTermsRepository;
    @Autowired
    private ContractCompanyService contractCompanyService;

    public Contract getContract(String brandId, String contractId) {
        return this.contractRepository.getContractForBranch(brandId, contractId);
    }

    public Pair<ContractWrapper, SchoolWrapper> getContractDetailWrapper(String contractId, String schoolId, School school) {
        ContractCompany cc;
        List<ContractPostpone> postpones;
        Contract contract = this.contractRepository.getContract(contractId, schoolId);
        ContractDetail contractDetail = this.contractRepository.getContractDetail(contractId, schoolId);
        if (contract == null) {
            this.logger.error("\u83b7\u53d6\u4e0d\u5230\u5408\u540c\u4fe1\u606f");
            return null;
        }
        if (contractDetail == null) {
            this.logger.error("\u5408\u540c\u4fe1\u606f\u7f3a\u5931\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
            return null;
        }
        ContractWrapper contractWrapper = ContractWrapper.of(contract);
        contractWrapper.setContractDetail(contractDetail);
        List<StudentSchoolContract> sscs = this.studentSchoolContractRepository.getSSCByContractId(schoolId, contractId);
        if (ArrayMapTools.isEmpty(sscs)) {
            this.logger.error("\u5408\u540c\u5b66\u751f\u4fe1\u606f\u7f3a\u5931\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
            return null;
        }
        ArrayList students = Lists.newArrayList();
        for (StudentSchoolContract ssc : sscs) {
            StudentInfo si = this.studentInfoRepository.getStudent(ssc.getSuid());
            if (si == null) {
                this.logger.warn("\u5408\u540c\u5b66\u5458\u4fe1\u606f\u4e0d\u5b58\u5728:" + ssc.getSuid());
                return null;
            }
            students.add(ContractStudentWrapper.ofStudentInfo(si));
        }
        contractWrapper.setStudents(students);
        contractWrapper.setParent(this.parentInfoService.getParentWrapper(contract.getPuid()));
        contractWrapper.setCoursePack(this.coursePackService.getCoursePackWrapper(school.getBrandId(), school.getProv(), school.getCity(), schoolId, contract.getCoursePackId()));
        List<Integer> courseIds = this.coursePackService.getCoursesByPackId(school.getBrandId(), school.getProv(), school.getCity(), schoolId, contract.getCoursePackId());
        if (ArrayMapTools.isNotEmpty(courseIds)) {
            Map<Integer, CourseWrapper> courseMap = this.courseService.mutiGetCourseInfoMap(school.getBrandId(), schoolId, courseIds, false);
            if (ArrayMapTools.isNotEmpty(courseIds)) {
                contractWrapper.setCourses(courseMap.values());
            }
        }
        HashSet fuids = Sets.newHashSet();
        if (StringUtils.isNotEmpty((CharSequence)contract.getAdviser())) {
            fuids.add(contract.getAdviser());
        }
        if (StringUtils.isNotEmpty((CharSequence)contract.getAdviser2())) {
            fuids.add(contract.getAdviser2());
        }
        if (StringUtils.isNotEmpty((CharSequence)contract.getTeacher())) {
            fuids.add(contract.getTeacher());
        }
        if (StringUtils.isNotEmpty((CharSequence)contract.getTeacher2())) {
            fuids.add(contract.getTeacher2());
        }
        if (StringUtils.isNotEmpty((CharSequence)contract.getMarket())) {
            fuids.add(contract.getMarket());
        }
        Map<String, UserSimpleWrapper> userMap = null;
        if (ArrayMapTools.isNotEmpty((Collection)fuids)) {
            userMap = this.fUserInfoService.mutiGetUserWrappers(fuids);
        }
        if (StringUtils.isNotEmpty((CharSequence)contract.getAdviser())) {
            contractWrapper.setAdviser(userMap.get(contract.getAdviser()));
        }
        if (StringUtils.isNotEmpty((CharSequence)contract.getAdviser2())) {
            contractWrapper.setAdviser2(userMap.get(contract.getAdviser2()));
            contractWrapper.setAdviser2Rat(contract.getAdviser2Rat());
        }
        if (StringUtils.isNotEmpty((CharSequence)contract.getTeacher())) {
            contractWrapper.setTeacher(userMap.get(contract.getTeacher()));
        }
        if (StringUtils.isNotEmpty((CharSequence)contract.getTeacher2())) {
            contractWrapper.setTeacher2(userMap.get(contract.getTeacher2()));
        }
        if (StringUtils.isNotEmpty((CharSequence)contract.getMarket())) {
            contractWrapper.setMarket(userMap.get(contract.getMarket()));
        }
        if (ArrayMapTools.isNotEmpty(postpones = this.contractPostponeRepository.getPayedPostpones(schoolId, contractId))) {
            ArrayList pps = Lists.newArrayList();
            for (ContractPostpone cp : postpones) {
                pps.add(ContractPostponeWrapper.of(cp));
            }
            contractWrapper.setPostpones(pps);
        }
        contractWrapper.setSerialNum(school.getCode() + "" + contract.getPayTime());
        contractWrapper.setParentSignContent(this.contractRepository.getParentSignContent(contractId));
        if (StringUtils.isNotEmpty((CharSequence)contractDetail.getTermId())) {
            contractWrapper.setTermsDetails(this.contractTermsRepository.getDetails(schoolId, contractDetail.getTermId()));
            contractWrapper.setTermsRemark(this.contractTermsRepository.getRemark(schoolId, contractDetail.getTermId()));
        }
        SchoolWrapper schoolWrapper = SchoolWrapper.ofContract(school);
        if (contractDetail.getCompanyId() != null && (cc = this.contractCompanyService.getContractCompany(schoolId, contractDetail.getCompanyId())) != null) {
            schoolWrapper.setCompany(cc.getCompany()).setStamp(cc.getStamp());
        }
        return Pair.of((Object)contractWrapper, (Object)schoolWrapper);
    }

    public List<ContractWrapper> getParentContractList(String brandId, String puid, boolean needNoPay) {
        List<Contract> contracts = needNoPay ? this.contractRepository.getUserContractList(brandId, puid) : this.contractRepository.getPayedContractList(brandId, puid);
        ArrayList list = Lists.newArrayList();
        if (ArrayMapTools.isEmpty(contracts)) {
            return list;
        }
        List<String> contractIds = contracts.stream().map(it -> it.getContractId()).collect(Collectors.toList());
        List<Map<String, Object>> consumeList = this.studentSchoolContractRepository.mutiCalContractConsumes(contractIds);
        HashMap consumeOfficalLessonMap = Maps.newHashMap();
        HashMap noScheduleOfficalLessonMap = Maps.newHashMap();
        for (Map<String, Object> map : consumeList) {
            String contractId = MapUtils.getString(map, (Object)"contractId");
            consumeOfficalLessonMap.put(contractId, MapUtils.getIntValue(map, (Object)"consumeOfficalLesson"));
            noScheduleOfficalLessonMap.put(contractId, MapUtils.getIntValue(map, (Object)"noScheduleOfficalLesson"));
        }
        HashMap leftExtraLessonMap = Maps.newHashMap();
        HashMap consumeMap = Maps.newHashMap();
        List<StudentSchoolExtra> extras = this.studentSchoolContractRepository.mutiGetContractExtras(contractIds);
        if (ArrayMapTools.isNotEmpty(extras)) {
            for (StudentSchoolExtra extra : extras) {
                if (extra.getTotal() <= extra.getConsume()) continue;
                leftExtraLessonMap.put(extra.getContractId(), MapUtils.getIntValue((Map)leftExtraLessonMap, (Object)extra.getContractId()) + extra.getTotal() - extra.getConsume());
                consumeMap.put(extra.getContractId(), MapUtils.getIntValue((Map)consumeMap, (Object)extra.getContractId()) + extra.getConsume());
            }
        }
        for (Contract c : contracts) {
            ContractWrapper wrapper = ContractWrapper.of(c);
            int consumeOfficalLesson = MapUtils.getIntValue((Map)consumeOfficalLessonMap, (Object)c.getContractId());
            wrapper.setConsumeOfficalLesson(consumeOfficalLesson);
            wrapper.setNoScheduleOfficalLesson(MapUtils.getIntValue((Map)noScheduleOfficalLessonMap, (Object)c.getContractId()));
            int extraLeftLesson = MapUtils.getIntValue((Map)leftExtraLessonMap, (Object)c.getContractId());
            wrapper.setExtraLeftLesson(extraLeftLesson);
            int totalLeftLesson = c.getTotalOfficalLesson() - consumeOfficalLesson + extraLeftLesson;
            wrapper.setTotalLeftLesson(totalLeftLesson);
            wrapper.setConsumeExtraLesson(MapUtils.getIntValue((Map)consumeMap, (Object)c.getContractId()));
            wrapper.setIsFinished(totalLeftLesson <= 0);
            if (c.getStatus() == 3 || c.getStatus() == 4) {
                wrapper.setStatus(104);
            } else if (c.getStatus() == 5) {
                wrapper.setStatus(105);
            } else if (c.getStatus() == 2 || c.getStatus() >= 40 && c.getStatus() <= 49) {
                wrapper.setStatus(106);
            } else if (c.getStatus() >= 10 && c.getStatus() < 20) {
                if (c.getParentSignStatus() == ContractParentSignStatus.waitSignAffect.code && (c.getStatus() == 10 || c.getStatus() == 12 || c.getStatus() == 14 || c.getStatus() == 16 || c.getStatus() == 18)) {
                    wrapper.setStatus(100);
                } else {
                    wrapper.setStatus(101);
                }
            } else {
                wrapper.setStatus(totalLeftLesson <= 0 ? 103 : 102);
            }
            list.add(wrapper);
        }
        return list;
    }

    public boolean isHaveContract(String brandId, String puid) {
        return this.contractRepository.isHaveContract(brandId, puid);
    }

    public boolean isOwnedContract(String branchId, String puid) {
        return this.contractRepository.isOwnedContract(branchId, puid);
    }

    public List<String> getContractedSchoolIds(String brandId, String puid) {
        return this.contractRepository.getContractedSchoolIds(brandId, puid);
    }

    public Contract getSimpleContract(String contractId) {
        return this.contractRepository.getSimpleContract(contractId);
    }

    public int cntWaitSignForAppOpen(String brandId, String puid) {
        return this.contractRepository.cntWaitParentSignForAppOpen(brandId, puid);
    }

    public List<String> getSchoolIds(String brandId, String puid) {
        return this.contractRepository.getSchoolIds(brandId, puid);
    }

    public boolean checkIsHaveContractAllBrand(String puid) {
        return this.contractRepository.checkIsHaveContractAllBrand(puid);
    }
}

