package com.jz.jar.franchise.repository;

import java.util.Collection;
import java.util.List;

import org.jooq.UpdateSetMoreStep;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Repository;

import com.jz.common.utils.text.StringTools;
import com.jz.jooq.franchise.Tables;
import com.jz.jooq.franchise.tables.pojos.ParentInfo;
import com.jz.jooq.franchise.tables.records.ParentInfoRecord;

@Lazy
@Repository
public class ParentInfoRepository extends FranchiseBaseRepository {

	private static final com.jz.jooq.franchise.tables.ParentInfo PI = Tables.PARENT_INFO;

	public void savePatentInfo(String puid, String phone, int appLogin) {
		ParentInfoRecord parent = new ParentInfoRecord();
		parent.setPuid(puid);
		parent.setPhone(phone);
		parent.setAppLogin(appLogin);
		parent.setCreated(System.currentTimeMillis());
		franchiseCtx.insertInto(PI).set(parent).onDuplicateKeyIgnore().execute();
	}

	public ParentInfo getParentInfoForPhone(String phone) {
		return franchiseCtx.selectFrom(PI).where(PI.PHONE.eq(phone)).fetchAnyInto(ParentInfo.class);
	}

	public void updateAppLogin(String phone) {
		franchiseCtx.update(PI).set(PI.APP_LOGIN, 1).where(PI.PHONE.eq(phone).and(PI.APP_LOGIN.eq(0))).execute();
	}

	public void updateAddressForUid(String puid, String address) {
		franchiseCtx.update(PI).set(PI.ADDRESS, address).where(PI.PUID.eq(puid)).execute();
	}

	public ParentInfo getParentInfoForId(String uid) {
		return franchiseCtx.selectFrom(PI).where(PI.PUID.eq(uid)).fetchAnyInto(ParentInfo.class);
	}

	public int countExistUid(String... uids) {
		return franchiseCtx.fetchCount(PI, PI.PUID.in(uids));
	}

	public ParentInfo getSimpleParentInfo(String puid) {
		return franchiseCtx.select(PI.PUID, PI.NAME, PI.AVATAR).from(PI).where(PI.PUID.eq(puid))
				.fetchAnyInto(ParentInfo.class);
	}

	public List<ParentInfo> getSimpleParentInfo(Collection<String> puids) {
		return franchiseCtx.select(PI.PUID, PI.NAME, PI.AVATAR).from(PI).where(PI.PUID.in(puids))
				.fetchInto(ParentInfo.class);
	}

	public List<ParentInfo> mutiGetParentInfo(Collection<String> puids) {
		return franchiseCtx.selectFrom(PI).where(PI.PUID.in(puids)).fetchInto(ParentInfo.class);
	}

	public void updateUserInfo(String puid, String name, String avatar) {
		UpdateSetMoreStep<ParentInfoRecord> moreStep = franchiseCtx.update(PI).set(PI.NAME, name);
		if (StringTools.isNotEmpty(avatar))
			moreStep = moreStep.set(PI.AVATAR, avatar);
		moreStep.where(PI.PUID.eq(puid)).execute();
	}

	public void updatePhoneForWriteOff(String puid, String phone) {
		franchiseCtx.update(PI).set(PI.PHONE, phone).where(PI.PUID.eq(puid)).execute();
	}
}
