package com.jz.jar.franchise.repository;

import java.util.List;

import org.apache.commons.lang3.tuple.Pair;
import org.jooq.Condition;
import org.jooq.impl.DSL;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Repository;

import com.google.common.collect.Lists;
import com.jz.jooq.franchise.Tables;
import com.jz.jooq.franchise.tables.pojos.Appraise;

@Lazy
@Repository
public class AppraiseRepository extends FranchiseBaseRepository {

	private static final com.jz.jooq.franchise.tables.Appraise A = Tables.APPRAISE;

	public List<Appraise> findAppraiseInfo(int courseId, List<Pair<Integer, String>> starCnt2Name) {
		List<Condition> ors = Lists.newArrayList();
		for (Pair<Integer, String> p : starCnt2Name) {
			ors.add(A.STAR_CNT.eq(p.getLeft()).and(A.NAME.eq(p.getRight())));
		}
		return franchiseCtx.selectFrom(A).where(A.COURSE_ID.eq(courseId).and(DSL.or(ors))).orderBy(A.DIMENSION)
				.fetchInto(Appraise.class);
	}
	
	public List<Appraise> listAppraiseByCourseId(int courseId) {
		return franchiseCtx.selectFrom(A).where(A.COURSE_ID.eq(courseId)).fetchInto(Appraise.class);
	}

}
