package com.jz.jar.franchise.service;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

import com.jz.jar.franchise.repository.RecruitRepository;
import com.jz.jooq.franchise.tables.pojos.Recruit;
import com.jz.jooq.franchise.tables.pojos.RecruitSchool;

@Lazy
@Service
public class RecruitService {

	@Autowired
	private RecruitRepository recruitRepository;
	
	public List<RecruitSchool> getRecruitArea() {
		return recruitRepository.getRecruitArea();
	}
	
	public int cntRecruits(String school, String prov, String city) {
		return recruitRepository.cntRecruits(school, prov, city);
	}

	public List<String> getRecruitIds(String school, String prov, String city, int start, int size) {
		return recruitRepository.getRecruitIds(school, prov, city, start, size);
	}

	public List<Recruit> getListRecruitInfo(List<String> rids) {
		return recruitRepository.getListRecruitInfo(rids);
	}

	public Recruit getRecruitInfo(String rid) {
		return recruitRepository.getRecruitInfo(rid);
	}

}
