/*
 * Decompiled with CFR 0.152.
 */
package com.jz.jar.franchise.repository;

import com.jz.jar.franchise.repository.FranchiseBaseRepository;
import com.jz.jooq.franchise.Tables;
import com.jz.jooq.franchise.tables.Contract;
import com.jz.jooq.franchise.tables.ContractDetail;
import java.util.List;
import org.jooq.Condition;
import org.jooq.SelectField;
import org.jooq.Table;
import org.jooq.TableLike;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Repository;

@Lazy
@Repository
public class ContractRepository
extends FranchiseBaseRepository {
    private static final Contract C = Tables.CONTRACT;
    private static final ContractDetail CD = Tables.CONTRACT_DETAIL;

    public com.jz.jooq.franchise.tables.pojos.Contract getContract(String contractId, String schoolId) {
        return (com.jz.jooq.franchise.tables.pojos.Contract)this.franchiseCtx.selectFrom((Table)C).where(new Condition[]{ContractRepository.C.CONTRACT_ID.eq((Object)contractId).and(ContractRepository.C.SCHOOL_ID.eq((Object)schoolId))}).fetchAnyInto(com.jz.jooq.franchise.tables.pojos.Contract.class);
    }

    public com.jz.jooq.franchise.tables.pojos.Contract getContractForBranch(String branchId, String contractId) {
        return (com.jz.jooq.franchise.tables.pojos.Contract)this.franchiseCtx.selectFrom((Table)C).where(new Condition[]{ContractRepository.C.CONTRACT_ID.eq((Object)contractId).and(ContractRepository.C.BRAND_ID.eq((Object)branchId))}).fetchAnyInto(com.jz.jooq.franchise.tables.pojos.Contract.class);
    }

    public com.jz.jooq.franchise.tables.pojos.ContractDetail getContractDetail(String contractId, String schoolId) {
        return (com.jz.jooq.franchise.tables.pojos.ContractDetail)this.franchiseCtx.selectFrom((Table)CD).where(new Condition[]{ContractRepository.CD.CONTRACT_ID.eq((Object)contractId).and(ContractRepository.CD.SCHOOL_ID.eq((Object)schoolId))}).fetchAnyInto(com.jz.jooq.franchise.tables.pojos.ContractDetail.class);
    }

    public List<com.jz.jooq.franchise.tables.pojos.Contract> getUserContractList(String branchId, String puid) {
        return this.franchiseCtx.selectFrom((Table)C).where(new Condition[]{ContractRepository.C.PUID.eq((Object)puid).and(ContractRepository.C.STATUS.eq((Object)1)).and(ContractRepository.C.BRAND_ID.eq((Object)branchId))}).orderBy(ContractRepository.C.PAY_TIME.desc()).fetchInto(com.jz.jooq.franchise.tables.pojos.Contract.class);
    }

    public boolean isHaveContract(String puid) {
        return this.franchiseCtx.fetchExists((Table)C, ContractRepository.C.PUID.eq((Object)puid).and(ContractRepository.C.STATUS.eq((Object)1)));
    }

    public com.jz.jooq.franchise.tables.pojos.Contract getSimpleContract(String contractId) {
        return (com.jz.jooq.franchise.tables.pojos.Contract)this.franchiseCtx.select((SelectField)ContractRepository.C.START_TIME).from((TableLike)C).where(new Condition[]{ContractRepository.C.CONTRACT_ID.eq((Object)contractId)}).fetchAnyInto(com.jz.jooq.franchise.tables.pojos.Contract.class);
    }
}

