/*
 * Decompiled with CFR 0.152.
 */
package com.jz.jar.franchise.cache;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;
import redis.clients.jedis.JedisCluster;

@Lazy
@Component
public class FranchiseTokenKeyCache {
    private Logger logger = LoggerFactory.getLogger(FranchiseTokenKeyCache.class);
    private static int expireTime = 36000;
    @Autowired
    private JedisCluster jedisCluster;

    private String genRedisKey(String uid) {
        return "tokenKey:{" + uid + "}";
    }

    public String getPwdPart(String uid) {
        try {
            String key = this.genRedisKey(uid);
            return this.jedisCluster.get(key);
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public void setPwdPart(String uid, String pwdPart) {
        try {
            String key = this.genRedisKey(uid);
            this.jedisCluster.set(key, pwdPart);
            this.jedisCluster.expire(key, expireTime);
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), (Throwable)e);
        }
    }

    public void delPwdPart(String uid) {
        try {
            String key = this.genRedisKey(uid);
            this.jedisCluster.del(key);
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), (Throwable)e);
        }
    }
}

