/*
 * Decompiled with CFR 0.152.
 */
package com.jz.jar.franchise.service;

import com.google.common.collect.Lists;
import com.jz.common.utils.collection.ArrayMapTools;
import com.jz.jar.franchise.repository.CoursePackRepository;
import com.jz.jar.franchise.wrapper.CoursePackWrapper;
import com.jz.jooq.franchise.tables.pojos.CoursePackSchool;
import com.jz.jooq.franchise.tables.pojos.CoursePackV2;
import com.jz.jooq.franchise.tables.pojos.CoursePackV2City;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@Lazy
@Service
public class CoursePackService {
    @Autowired
    private CoursePackRepository coursePackRepository;

    public List<Integer> getCoursesByPackId(String brandId, String prov, String city, String schoolId, String coursePackId) {
        List<Integer> courseIds = this.coursePackRepository.getHoCourseIds(brandId, coursePackId);
        if (ArrayMapTools.isEmpty(courseIds)) {
            courseIds = this.coursePackRepository.getSchoolCourseIds(schoolId, coursePackId);
        }
        return courseIds;
    }

    public CoursePackWrapper getCoursePackWrapper(String brandId, String prov, String city, String schoolId, String coursePackId) {
        CoursePackV2City price;
        CoursePackV2 hoPack = this.coursePackRepository.getCoursePackHo(brandId, coursePackId);
        if (hoPack != null && (price = this.coursePackRepository.getCoursePackCity(brandId, prov, city, coursePackId)) != null) {
            return CoursePackWrapper.of(hoPack, price);
        }
        CoursePackSchool schPack = this.coursePackRepository.getCoursePackSchool(schoolId, coursePackId);
        if (schPack != null) {
            return CoursePackWrapper.of(schPack);
        }
        return null;
    }

    public List<CoursePackWrapper> getEnableSchoolPacksWithPrice(String brandId, String prov, String city, String schoolId) {
        ArrayList list = Lists.newArrayList();
        List<CoursePackV2City> cityPrices = this.coursePackRepository.getEnablePackCity(brandId, prov, city);
        Map<String, CoursePackV2City> priceMap = cityPrices.stream().collect(Collectors.toMap(it -> it.getCoursePackId(), it -> it));
        List<CoursePackV2> cpInfos = this.coursePackRepository.mutiGetEnableCoursePackHoOrder(brandId, priceMap.keySet());
        for (CoursePackV2 cp : cpInfos) {
            CoursePackV2City price = priceMap.get(cp.getCoursePackId());
            if (price == null) continue;
            CoursePackWrapper wrapper = CoursePackWrapper.of(cp, price);
            list.add(wrapper);
        }
        return list;
    }
}

