package com.jz.jar.franchise.service;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

import com.jz.jar.franchise.repository.LessonStudentRepository;
import com.jz.jooq.franchise.tables.pojos.LessonStudent;

@Lazy
@Service
public class LessonStudentService {

	@Autowired
	private LessonStudentRepository lessonStudentRepository;
	
	public List<LessonStudent> findAllLessonForStudent(String suid) {
		return lessonStudentRepository.findAllLessonForStudent(suid);
	}
	
	public LessonStudent getLessonStudent(String schoolId, String lessonId, String suid) {
		return lessonStudentRepository.getLessonStudent(schoolId, lessonId, suid);
	}
	
	public void updateStatus(String schoolId, String lessonId, String suid, int status) {
		lessonStudentRepository.updateStatus(schoolId, lessonId, suid, status);
	}
	
	public List<LessonStudent> findFinishedLessonInfo(String suid) {
		return lessonStudentRepository.findFinishedLessonInfo(suid);
	}
}
