package com.jz.jar.franchise.repository;

import java.util.List;

import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Repository;

import com.jz.common.utils.collection.ArrayMapTools;
import com.jz.jooq.franchise.Tables;
import com.jz.jooq.franchise.tables.pojos.CourseHo;

@Lazy
@Repository
public class CourseHoRepository extends FranchiseBaseRepository {

	private static final com.jz.jooq.franchise.tables.CourseHo CH = Tables.COURSE_HO;

	public CourseHo getCourseHo(String brand, Integer courseId) {
		List<CourseHo> hos = franchiseCtx.selectFrom(CH).where(CH.BRAND_ID.eq(brand).and(CH.COURSE_ID.eq(courseId)))
				.fetchInto(CourseHo.class);
		return ArrayMapTools.isNotEmpty(hos) ? hos.get(0) : null;
	}
}
