package com.jz.jar.business.wrapper;

import java.util.List;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.jz.common.utils.collection.ArrayMapTools;
import com.jz.jooq.media.tables.pojos.WorksInfo;

public class WorksInfoWrapper {
	private WorksInfoWrapper() {
	}

	private String id;
	private String title;
	private String material; // 材料
	private String worksSize; // 尺寸
	private String infoArtHis; // 艺术流派
	private String appraise; // 评价
	private Boolean isOpen; // 是否公开
	private Boolean isCollective; // 是否集创
	private Long createTime;

	private String pic; // 封面图
	private List<String> pictures; // 图片集
	private List<String> createPics;
	private List<String> interactPics;
	private String audio;
	private Integer audioDuration;
	private WorksVideoWrapper video;

	private UserWrapper user;
	private StudentWrapper student;
	private List<StudentWrapper> authors;

	private WWorkTopicTheme theme; // 作品专题

	private Integer likeCnt;
	private Integer commentCnt;
	private Boolean isLike; // 当前用户是否已经喜欢
	private String lessonTitle; // 课程名称
	private String courseName; // 课阶名称
	private Long lessonStartTime;
	private Long lessonEndTime;
	private TeacherWrapper teacher;
	private Boolean isShowCourseInfo; // 是否展示课程信息

	private String schoolId;
	private String schoolName;
	private String lessonId;

	private String posterBottomTip1;
	private String posterBottomTip2;
	private String posterBottomQrPic;

	private WorksTreasureWrapper treasure;

	public static WorksInfoWrapper of(WorksInfo worksInfo) {
		return new WorksInfoWrapper().setId(worksInfo.getId()).setTitle(worksInfo.getTitle())
				.setMaterial(worksInfo.getMaterial()).setWorksSize(worksInfo.getWorksSize())
				.setInfoArtHis(worksInfo.getInfoArtHis()).setAppraise(worksInfo.getAppraise())
				.setIsOpen(worksInfo.getIsOpen() > 0).setIsCollective(worksInfo.getIsCollective() > 0)
				.setCreateTime(worksInfo.getCreateTime()).setSchoolId(worksInfo.getSchoolId())
				.setLessonId(worksInfo.getLessonId()).setIsShowCourseInfo(false);
	}

	public String getId() {
		return id;
	}

	public WorksInfoWrapper setId(String id) {
		this.id = id;
		return this;
	}

	public String getTitle() {
		return title;
	}

	public WorksInfoWrapper setTitle(String title) {
		this.title = title;
		return this;
	}

	public String getMaterial() {
		return material;
	}

	public WorksInfoWrapper setMaterial(String material) {
		this.material = material;
		return this;
	}

	public String getWorksSize() {
		return worksSize;
	}

	public WorksInfoWrapper setWorksSize(String worksSize) {
		this.worksSize = worksSize;
		return this;
	}

	public String getInfoArtHis() {
		return infoArtHis;
	}

	public WorksInfoWrapper setInfoArtHis(String infoArtHis) {
		this.infoArtHis = infoArtHis;
		return this;
	}

	public String getAppraise() {
		return appraise;
	}

	public WorksInfoWrapper setAppraise(String appraise) {
		this.appraise = appraise;
		return this;
	}

	public Boolean getIsOpen() {
		return isOpen;
	}

	public WorksInfoWrapper setIsOpen(Boolean isOpen) {
		this.isOpen = isOpen;
		return this;
	}

	public Boolean getIsCollective() {
		return isCollective;
	}

	public WorksInfoWrapper setIsCollective(Boolean isCollective) {
		this.isCollective = isCollective;
		return this;
	}

	public String getPic() {
		return pic;
	}

	public WorksInfoWrapper setPic(String pic) {
		this.pic = pic;
		return this;
	}

	public List<String> getPictures() {
		return pictures;
	}

	public WorksInfoWrapper setPictures(List<String> pictures) {
		this.pictures = pictures;
		return this;
	}

	public List<String> getCreatePics() {
		return createPics;
	}

	public WorksInfoWrapper setCreatePics(List<String> createPics) {
		this.createPics = createPics;
		return this;
	}

	public List<String> getInteractPics() {
		return interactPics;
	}

	public WorksInfoWrapper setInteractPics(List<String> interactPics) {
		this.interactPics = interactPics;
		return this;
	}

	public Long getCreateTime() {
		return createTime;
	}

	public WorksInfoWrapper setCreateTime(Long createTime) {
		this.createTime = createTime;
		return this;
	}

	public UserWrapper getUser() {
		return user;
	}

	public WorksInfoWrapper setUser(UserWrapper user) {
		this.user = user;
		return this;
	}

	public StudentWrapper getStudent() {
		return student;
	}

	public WorksInfoWrapper setStudent(StudentWrapper student) {
		this.student = student;
		return this;
	}

	public List<StudentWrapper> getAuthors() {
		return authors;
	}

	public WorksInfoWrapper setAuthors(List<StudentWrapper> authors) {
		if (ArrayMapTools.isNotEmpty(authors)) {
			student = authors.get(0);
		}
		this.authors = authors;
		return this;
	}

	public WWorkTopicTheme getTheme() {
		return theme;
	}

	public WorksInfoWrapper setTheme(WWorkTopicTheme theme) {
		this.theme = theme;
		return this;
	}

	public Boolean getIsLike() {
		return isLike;
	}

	public WorksInfoWrapper setIsLike(Boolean isLike) {
		this.isLike = isLike;
		return this;
	}

	public Integer getLikeCnt() {
		return likeCnt;
	}

	public WorksInfoWrapper setLikeCnt(Integer likeCnt) {
		this.likeCnt = likeCnt;
		return this;
	}

	public Integer getCommentCnt() {
		return commentCnt;
	}

	public WorksInfoWrapper setCommentCnt(Integer commentCnt) {
		this.commentCnt = commentCnt;
		return this;
	}

	public String getLessonTitle() {
		return lessonTitle;
	}

	public WorksInfoWrapper setLessonTitle(String lessonTitle) {
		this.lessonTitle = lessonTitle;
		return this;
	}

	public String getCourseName() {
		return courseName;
	}

	public WorksInfoWrapper setCourseName(String courseName) {
		this.courseName = courseName;
		return this;
	}

	public Long getLessonStartTime() {
		return lessonStartTime;
	}

	public WorksInfoWrapper setLessonStartTime(Long lessonStartTime) {
		this.lessonStartTime = lessonStartTime;
		return this;
	}

	public Long getLessonEndTime() {
		return lessonEndTime;
	}

	public WorksInfoWrapper setLessonEndTime(Long lessonEndTime) {
		this.lessonEndTime = lessonEndTime;
		return this;
	}

	public TeacherWrapper getTeacher() {
		return teacher;
	}

	public WorksInfoWrapper setTeacher(TeacherWrapper teacher) {
		this.teacher = teacher;
		return this;
	}

	public Boolean getIsShowCourseInfo() {
		return isShowCourseInfo;
	}

	public WorksInfoWrapper setIsShowCourseInfo(Boolean isShowCourseInfo) {
		this.isShowCourseInfo = isShowCourseInfo;
		return this;
	}

	@JsonIgnore
	public String getSchoolId() {
		return schoolId;
	}

	public WorksInfoWrapper setSchoolId(String schoolId) {
		this.schoolId = schoolId;
		return this;
	}

	public String getSchoolName() {
		return schoolName;
	}

	public WorksInfoWrapper setSchoolName(String schoolName) {
		this.schoolName = schoolName;
		return this;
	}

	@JsonIgnore
	public String getLessonId() {
		return lessonId;
	}

	public WorksInfoWrapper setLessonId(String lessonId) {
		this.lessonId = lessonId;
		return this;
	}

	public String getAudio() {
		return audio;
	}

	public WorksInfoWrapper setAudio(String audio) {
		this.audio = audio;
		return this;
	}

	public WorksVideoWrapper getVideo() {
		return video;
	}

	public WorksInfoWrapper setVideo(WorksVideoWrapper video) {
		this.video = video;
		return this;
	}

	public Integer getAudioDuration() {
		return audioDuration;
	}

	public WorksInfoWrapper setAudioDuration(Integer audioDuration) {
		this.audioDuration = audioDuration;
		return this;
	}

	public String getPosterBottomTip1() {
		return posterBottomTip1;
	}

	public WorksInfoWrapper setPosterBottomTip1(String posterBottomTip1) {
		this.posterBottomTip1 = posterBottomTip1;
		return this;
	}

	public String getPosterBottomTip2() {
		return posterBottomTip2;
	}

	public WorksInfoWrapper setPosterBottomTip2(String posterBottomTip2) {
		this.posterBottomTip2 = posterBottomTip2;
		return this;
	}

	public String getPosterBottomQrPic() {
		return posterBottomQrPic;
	}

	public WorksInfoWrapper setPosterBottomQrPic(String posterBottomQrPic) {
		this.posterBottomQrPic = posterBottomQrPic;
		return this;
	}

	public WorksTreasureWrapper getTreasure() {
		return treasure;
	}

	public WorksInfoWrapper setTreasure(WorksTreasureWrapper treasure) {
		this.treasure = treasure;
		return this;
	}

}
