package com.jz.jar.business.wrapper;

import com.jz.jar.business.bean.AliyunBean;
import com.jz.jooq.media.tables.pojos.SchoolWorksTopic;

public class WWorkTopicWrapper {
	private WWorkTopicWrapper() {
	}

	private String tid;
	private String name;
	private String subName;
	private String remark;
	private String coverPic;
	private String sharePic;
	private String kvPic;
	private String xcxQr;
	private Integer displayType;
	private Integer worksNum;
	private Long createTime;

	public static WWorkTopicWrapper of(SchoolWorksTopic t) {
		return new WWorkTopicWrapper().setTid(t.getTid()).setName(t.getName()).setSubName(t.getSubName())
				.setRemark(t.getRemark()).setCoverPic(t.getCoverPic()).setSharePic(t.getSharePic())
				.setKvPic(t.getKvPic()).setXcxQr(t.getXcxQr()).setDisplayType(t.getDisplayType())
				.setWorksNum(t.getWorksNum()).setCreateTime(t.getCreateTime());
	}

	public String getTid() {
		return tid;
	}

	public WWorkTopicWrapper setTid(String tid) {
		this.tid = tid;
		return this;
	}

	public String getName() {
		return name;
	}

	public WWorkTopicWrapper setName(String name) {
		this.name = name;
		return this;
	}

	public String getSubName() {
		return subName;
	}

	public WWorkTopicWrapper setSubName(String subName) {
		this.subName = subName;
		return this;
	}

	public String getCoverPic() {
		return coverPic;
	}

	public WWorkTopicWrapper setCoverPic(String coverPic) {
		this.coverPic = AliyunBean.getImagesUrl(coverPic);
		return this;
	}

	public Integer getDisplayType() {
		return displayType;
	}

	public WWorkTopicWrapper setDisplayType(Integer displayType) {
		this.displayType = displayType;
		return this;
	}

	public Integer getWorksNum() {
		return worksNum;
	}

	public WWorkTopicWrapper setWorksNum(Integer worksNum) {
		this.worksNum = worksNum;
		return this;
	}

	public Long getCreateTime() {
		return createTime;
	}

	public WWorkTopicWrapper setCreateTime(Long createTime) {
		this.createTime = createTime;
		return this;
	}

	public String getRemark() {
		return remark;
	}

	public WWorkTopicWrapper setRemark(String remark) {
		this.remark = remark;
		return this;
	}

	public String getSharePic() {
		return sharePic;
	}

	public WWorkTopicWrapper setSharePic(String sharePic) {
		this.sharePic = AliyunBean.getImagesUrl(sharePic);
		return this;
	}

	public String getKvPic() {
		return kvPic;
	}

	public WWorkTopicWrapper setKvPic(String kvPic) {
		this.kvPic = AliyunBean.getImagesUrl(kvPic);
		return this;
	}

	public String getXcxQr() {
		return xcxQr;
	}

	public WWorkTopicWrapper setXcxQr(String xcxQr) {
		this.xcxQr = AliyunBean.getImagesUrl(xcxQr);
		return this;
	}

}
