/*
 * Decompiled with CFR 0.152.
 */
package com.jz.jar.business.proxy.common;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gson.reflect.TypeToken;
import com.jz.common.utils.collection.ArrayMapTools;
import com.jz.common.utils.collection.OrderTool;
import com.jz.common.utils.json.GsonTools;
import com.jz.common.utils.text.StringTools;
import com.jz.jar.business.bean.AliyunBean;
import com.jz.jar.business.proxy.common.UserProxy;
import com.jz.jar.business.request.UserRequest;
import com.jz.jar.business.request.WorksRequest;
import com.jz.jar.business.wrapper.StudentWrapper;
import com.jz.jar.business.wrapper.TeacherWrapper;
import com.jz.jar.business.wrapper.UserWrapper;
import com.jz.jar.business.wrapper.WWorkTopicTheme;
import com.jz.jar.business.wrapper.WorksInfoWrapper;
import com.jz.jar.business.wrapper.WorksTreasureWrapper;
import com.jz.jar.franchise.service.CourseTomatoTopicService;
import com.jz.jar.franchise.service.FUserInfoService;
import com.jz.jar.franchise.service.LessonService;
import com.jz.jar.franchise.service.SchoolService;
import com.jz.jar.franchise.service.StudentSchoolService;
import com.jz.jar.media.enums.BrandEnum;
import com.jz.jar.media.enums.DbField;
import com.jz.jar.media.service.CommentInfoService;
import com.jz.jar.media.service.WorksAuthorService;
import com.jz.jar.media.service.WorksInfoService;
import com.jz.jar.media.service.WorksLikeService;
import com.jz.jar.media.service.WorksTreasureService;
import com.jz.jooq.franchise.tables.pojos.CourseTomatoTopic;
import com.jz.jooq.franchise.tables.pojos.FuserInfo;
import com.jz.jooq.media.tables.pojos.WorksInfo;
import com.jz.jooq.media.tables.pojos.WorksTreasure;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@Lazy
@Service
public class WorksInfoProxy {
    private static final Type pictureType = new TypeToken<List<String>>(){}.getType();
    @Autowired
    private CourseTomatoTopicService courseTomatoTopicService;
    @Autowired
    private WorksInfoService worksInfoService;
    @Autowired
    private WorksLikeService worksLikeService;
    @Autowired
    private UserProxy userProxy;
    @Autowired
    private CommentInfoService commentInfoService;
    @Autowired
    private WorksAuthorService worksAuthorService;
    @Autowired
    private SchoolService schoolService;
    @Autowired
    private LessonService lessonService;
    @Autowired
    private FUserInfoService teacherService;
    @Autowired
    private WorksTreasureService worksTreasureService;
    @Autowired
    private StudentSchoolService studentSchoolService;

    public List<WorksInfoWrapper> getSimpleWorksInfo(BrandEnum brand, WorksRequest request) {
        List wts;
        if (ArrayMapTools.isEmpty(request.getWorksId())) {
            return null;
        }
        List worksInfo = this.worksInfoService.findSimpleWorksInfo(request.getWorksId());
        if (ArrayMapTools.isEmpty((Collection)worksInfo)) {
            return null;
        }
        Map<String, UserWrapper> uid2User = null;
        Map schoolId2Name = null;
        Map<String, StudentWrapper> suid2Student = null;
        Map likeCount = null;
        List likes = null;
        HashMap wkid2Puid2Suid = Maps.newHashMap();
        HashMap workId2Suids = Maps.newHashMap();
        HashMap lessonId2Teacher = Maps.newHashMap();
        if (request.getWithExtended()) {
            ArrayList wkids = Lists.newArrayList();
            HashMap school2Lessons = Maps.newHashMap();
            worksInfo.forEach(it -> {
                wkids.add(it.getId());
                if (school2Lessons.containsKey(it.getSchoolId())) {
                    ((Collection)school2Lessons.get(it.getSchoolId())).add(it.getLessonId());
                } else {
                    school2Lessons.put(it.getSchoolId(), Lists.newArrayList((Object[])new String[]{it.getLessonId()}));
                }
            });
            List worksAuthors = this.worksAuthorService.findWorkAuthor(brand, (Collection)wkids);
            HashSet puids = Sets.newHashSet();
            HashSet suids = Sets.newHashSet();
            HashSet schoolIds = Sets.newHashSet();
            worksAuthors.forEach(v -> {
                wkid2Puid2Suid.put(v.getWorkId(), Pair.of((Object)v.getPuid(), (Object)v.getSuid()));
                puids.add(v.getPuid());
                suids.add(v.getSuid());
                schoolIds.add(v.getSchoolId());
                if (workId2Suids.containsKey(v.getWorkId())) {
                    ((List)workId2Suids.get(v.getWorkId())).add(v.getSuid());
                } else {
                    workId2Suids.put(v.getWorkId(), Lists.newArrayList((Object[])new String[]{v.getSuid()}));
                }
            });
            schoolId2Name = this.schoolService.mutiGetId2NameMap((Collection)schoolIds);
            uid2User = this.userProxy.getSimpleParentInfoHas(brand, UserRequest.of(puids));
            suid2Student = this.userProxy.getStudentSimpleInfoHasForSuid(suids, brand, request.getUid());
            likeCount = this.worksLikeService.getLikeCount(request.getWorksId());
            if (null != request.getUid()) {
                likes = this.worksLikeService.screenLike(request.getWorksId(), request.getUid());
            }
            if (ArrayMapTools.isNotEmpty((Map)school2Lessons)) {
                Map lessonId2TeacherId = this.lessonService.getLessonId2Teacher((Map)school2Lessons);
                Map<String, FuserInfo> uMap = this.teacherService.getTeachers(lessonId2TeacherId.values()).stream().collect(Collectors.toMap(m -> m.getUid(), m -> m));
                for (Map.Entry m2 : lessonId2TeacherId.entrySet()) {
                    lessonId2Teacher.put(m2.getKey(), uMap.get(m2.getValue()));
                }
            }
        }
        HashMap teasureMap = null;
        if (request.getWithTreasure() && ArrayMapTools.isNotEmpty((Collection)(wts = this.worksTreasureService.mutiGetPayedTreasureByWorkIds(request.getWorksId())))) {
            teasureMap = Maps.newHashMap();
            for (WorksTreasure wt : wts) {
                WorksTreasureWrapper wtw = WorksTreasureWrapper.of(wt);
                if (StringUtils.equals((CharSequence)wt.getPuid(), (CharSequence)request.getUid())) {
                    wtw.setCertPic(wt.getCertPic());
                }
                teasureMap.put(wt.getWorkId(), wtw);
            }
        }
        ArrayList wrappers = Lists.newArrayList();
        for (WorksInfo workInfo : worksInfo) {
            WorksInfoWrapper wrapper = WorksInfoWrapper.of(workInfo);
            if (null != workInfo.getPic() && workInfo.getPic().startsWith("http://")) {
                wrapper.setPic(workInfo.getPic());
            } else {
                wrapper.setPic(AliyunBean.getImagesUrl(workInfo.getPic()));
            }
            if (request.getWithPictures() && StringTools.isNotEmptyAndBlank((String)workInfo.getPictures())) {
                List pics = (List)GsonTools.gson.fromJson(workInfo.getPictures(), pictureType);
                if (null != workInfo.getPic() && workInfo.getPic().startsWith("http://")) {
                    wrapper.setPictures(pics);
                }
                ArrayList pictures = Lists.newArrayList();
                pics.forEach(it -> pictures.add(AliyunBean.getImagesUrl(it)));
                wrapper.setPictures(pictures);
            }
            if (request.getWithExtended()) {
                Pair pair = (Pair)wkid2Puid2Suid.get(workInfo.getId());
                if (pair != null) {
                    wrapper.setUser(uid2User.get(pair.getKey()));
                    wrapper.setStudent(suid2Student.get(pair.getValue()));
                    wrapper.setLikeCnt(MapUtils.getInteger((Map)likeCount, (Object)workInfo.getId(), (Integer)0));
                    wrapper.setIsLike(null != likes && likes.contains(workInfo.getId()));
                }
                if (schoolId2Name.containsKey(workInfo.getSchoolId())) {
                    wrapper.setSchoolName((String)schoolId2Name.get(workInfo.getSchoolId()));
                }
                if (lessonId2Teacher.containsKey(workInfo.getLessonId())) {
                    wrapper.setTeacher(TeacherWrapper.of((FuserInfo)lessonId2Teacher.get(workInfo.getLessonId())));
                }
            }
            if (request.getWithStudent() && workId2Suids.containsKey(workInfo.getId())) {
                List suids = (List)workId2Suids.get(workInfo.getId());
                ArrayList authors = Lists.newArrayList();
                for (String tmpSuid : suids) {
                    authors.add(suid2Student.get(tmpSuid));
                }
                wrapper.setAuthors(authors);
            }
            if (request.getWithTreasure() && teasureMap != null) {
                wrapper.setTreasure((WorksTreasureWrapper)teasureMap.get(workInfo.getId()));
            }
            wrappers.add(wrapper);
        }
        return OrderTool.keepOrder(request.getWorksId(), (Collection)wrappers, WorksInfoWrapper::getId);
    }

    public Map<String, WorksInfoWrapper> getSimpleWorksInfoHas(BrandEnum brand, WorksRequest request) {
        List<WorksInfoWrapper> artInfo = this.getSimpleWorksInfo(brand, request);
        if (ArrayMapTools.isEmpty(artInfo)) {
            return Maps.newHashMap();
        }
        HashMap id2Art = Maps.newHashMap();
        artInfo.forEach(it -> id2Art.put(it.getId(), it));
        return id2Art;
    }

    public WorksInfoWrapper getWorkInfo(BrandEnum brand, WorksRequest request) {
        return this.getWorkInfoForRequest(brand, request.setWithExtended(true));
    }

    public WorksInfoWrapper getWorkInfoForRequest(BrandEnum brand, WorksRequest request) {
        WorksTreasure wt;
        boolean isOldData;
        WorksInfo workInfo = this.worksInfoService.getWorksInfo(request.getWorkId(), brand);
        if (null == workInfo) {
            return null;
        }
        if (workInfo.getIsCollective() <= 0) {
            boolean isMaster = workInfo.getPuid().equals(request.getUid());
            if (workInfo.getIsOpen() <= 0 && !isMaster) {
                return null;
            }
        }
        WorksInfoWrapper wrapper = WorksInfoWrapper.of(workInfo);
        if (StringUtils.isNotEmpty((CharSequence)workInfo.getSchoolId())) {
            wrapper.setSchoolName(this.schoolService.getSchoolName(workInfo.getSchoolId()));
        }
        boolean bl = isOldData = null != workInfo.getPic() && workInfo.getPic().startsWith("http://");
        if (isOldData) {
            wrapper.setPic(workInfo.getPic());
        } else {
            wrapper.setPic(AliyunBean.getImagesUrl(workInfo.getPic()));
        }
        if (StringTools.isNotEmptyAndBlank((String)workInfo.getPictures())) {
            List pics = (List)GsonTools.gson.fromJson(workInfo.getPictures(), pictureType);
            if (isOldData) {
                wrapper.setPictures(pics);
            } else {
                ArrayList pictures = Lists.newArrayList();
                pics.forEach(it -> pictures.add(AliyunBean.getImagesUrl(it)));
                wrapper.setPictures(pictures);
            }
        }
        if (request.getWithCreateInteractPics()) {
            if (StringUtils.isNotEmpty((CharSequence)workInfo.getCreatePics())) {
                List createPics = (List)GsonTools.gson.fromJson(workInfo.getCreatePics(), pictureType);
                wrapper.setCreatePics(createPics.stream().map(it -> AliyunBean.getImagesUrl(it)).collect(Collectors.toList()));
            }
            if (StringUtils.isNotEmpty((CharSequence)workInfo.getInteractPics())) {
                List interactPics = (List)GsonTools.gson.fromJson(workInfo.getInteractPics(), pictureType);
                wrapper.setInteractPics(interactPics.stream().map(it -> AliyunBean.getImagesUrl(it)).collect(Collectors.toList()));
            }
        }
        if (request.getWithExtended()) {
            CourseTomatoTopic topic = this.courseTomatoTopicService.getTopic(brand.name(), workInfo.getTid());
            if (null != topic) {
                wrapper.setTheme(WWorkTopicTheme.of(topic).setPic(AliyunBean.getImagesUrl(topic.getPic())));
            }
            wrapper.setLikeCnt(this.worksLikeService.countForWorkId(workInfo.getId()));
            wrapper.setCommentCnt(this.commentInfoService.countCommentInfo(brand, DbField.works, workInfo.getId()));
            wrapper.setIsLike(this.worksLikeService.existForIdAndUid(workInfo.getId(), request.getUid()));
            String puid = this.worksAuthorService.getWorksAuthorParent(brand, workInfo.getId());
            wrapper.setUser((UserWrapper)this.userProxy.getSimpleParentInfo(brand, UserRequest.of(request.getUid(), puid)));
        }
        if (request.getWithStudent()) {
            List suids = this.worksAuthorService.getWorksAuthors(brand, workInfo.getId());
            List<StudentWrapper> authors = this.userProxy.getStudentSimpleInfo(suids, brand, request.getWithAuthorUser(), request.getUid());
            wrapper.setAuthors(authors);
            if (StringUtils.isNotEmpty((CharSequence)workInfo.getSchoolId()) && ArrayMapTools.isNotEmpty(authors) && authors.size() == 1) {
                StudentWrapper author = authors.get(0);
                Long firstContractTime = this.studentSchoolService.getFirstContractTime(author.getSuid(), workInfo.getSchoolId());
                author.setJoinTime(this.userProxy.calLearnTimeStr(firstContractTime));
            }
        }
        if (request.getWithTreasure() && (wt = this.worksTreasureService.getPayedTreasureByWorkId(workInfo.getId())) != null) {
            WorksTreasureWrapper wtw = WorksTreasureWrapper.of(wt);
            if (StringUtils.equals((CharSequence)wt.getPuid(), (CharSequence)request.getUid())) {
                wtw.setCertPic(wt.getCertPic());
            }
            wrapper.setTreasure(wtw);
        }
        return wrapper;
    }
}

