package com.jz.jar.business.wrapper;

import com.jz.jar.business.bean.AliyunBean;
import com.jz.jooq.media.tables.pojos.WorksTreasure;

public class WorksTreasureWrapper {
	private WorksTreasureWrapper() {
	}

	private String id;
	private String workId;
	private String pic;
	private String title;
	private String createConcept;
	private String childName;
	private Long createTime;
	private String certificateNo;
	private String certPic; // 只有本身可以显示certPic

	public static WorksTreasureWrapper of(WorksTreasure t) {
		return new WorksTreasureWrapper().setId(t.getId()).setWorkId(t.getWorkId()).setPic(t.getPic())
				.setTitle(t.getTitle()).setCreateConcept(t.getCreateConcept()).setChildName(t.getChildName())
				.setCreateTime(t.getCreateTime()).setCertificateNo(t.getCertificateStorageNo());
	}

	public String getId() {
		return id;
	}

	public WorksTreasureWrapper setId(String id) {
		this.id = id;
		return this;
	}

	public String getWorkId() {
		return workId;
	}

	public WorksTreasureWrapper setWorkId(String workId) {
		this.workId = workId;
		return this;
	}

	public String getPic() {
		return pic;
	}

	public WorksTreasureWrapper setPic(String pic) {
		this.pic = AliyunBean.getImagesUrl(pic);
		return this;
	}

	public String getTitle() {
		return title;
	}

	public WorksTreasureWrapper setTitle(String title) {
		this.title = title;
		return this;
	}

	public String getCreateConcept() {
		return createConcept;
	}

	public WorksTreasureWrapper setCreateConcept(String createConcept) {
		this.createConcept = createConcept;
		return this;
	}

	public String getChildName() {
		return childName;
	}

	public WorksTreasureWrapper setChildName(String childName) {
		this.childName = childName;
		return this;
	}

	public Long getCreateTime() {
		return createTime;
	}

	public WorksTreasureWrapper setCreateTime(Long createTime) {
		this.createTime = createTime;
		return this;
	}

	public String getCertPic() {
		return certPic;
	}

	public WorksTreasureWrapper setCertPic(String certPic) {
		this.certPic = AliyunBean.getImagesUrl(certPic);
		return this;
	}

	public String getCertificateNo() {
		return certificateNo;
	}

	public WorksTreasureWrapper setCertificateNo(String certificateNo) {
		this.certificateNo = certificateNo;
		return this;
	}

}
