package com.jz.jar.business.proxy.common;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

import org.apache.commons.collections.MapUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

import com.aliyun.opensearch.sdk.dependencies.com.google.common.collect.Lists;
import com.jz.common.utils.collection.ArrayMapTools;
import com.jz.jar.franchise.service.CourseTomatoOsService;
import com.jz.jar.franchise.service.CourseTomatoService;
import com.jz.jar.franchise.wrapper.OnlineLessonWrapper;
import com.jz.jooq.franchise.tables.pojos.CourseTomatoPlanOs;

@Lazy
@Service
public class OnlineLessonProxy {

	@Autowired
	private CourseTomatoOsService courseTomatoOsService;
	@Autowired
	private CourseTomatoService courseTomatoService;

	public List<OnlineLessonWrapper> mutiGetFreeOnlineLessonByCourseIds(String brandId, Collection<Integer> courseIds) {
		List<CourseTomatoPlanOs> oss = courseTomatoOsService.mutiGetAllowOs(brandId, courseIds);
		if (ArrayMapTools.isEmpty(oss)) {
			return null;
		}
		List<String> planIds = oss.stream().map(os -> os.getPlanId()).collect(Collectors.toList());

		Map<Integer, String> courseNameMap = courseTomatoService.getCourseTomatoNameForIds(brandId, courseIds);
		Map<String, String> planNameMap = courseTomatoService.mutiGetPlanMap(brandId, planIds);

		List<OnlineLessonWrapper> rsList = Lists.newArrayList();
		for (CourseTomatoPlanOs os : oss) {
			OnlineLessonWrapper wrapper = OnlineLessonWrapper.of(os, 0);
			wrapper.setCourseName(MapUtils.getString(courseNameMap, os.getCourseId(), ""));
			wrapper.setLessonName(MapUtils.getString(planNameMap, os.getPlanId(), ""));
			rsList.add(wrapper);
		}
		return rsList;
	}

}
