package com.jz.jar.business.bean;

import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

import com.jz.jar.business.wrapper.WechatOffiaccount;
import com.jz.jar.media.enums.BrandEnum;

/**
 * @Title WechatOffiaccountGlobal
 * @Package com.jz.jar.business.bean
 * @author tangjunfeng
 * @date 2019年11月1日 上午10:57:13
 * @version V1.0
 */
@Component
public class WechatOffiaccountGlobal {

	private static WechatOffiaccountGlobal _this;

	public WechatOffiaccountGlobal() {
		_this = this;
	}

	@Value("${tomato.wechat.official.account.appid}")
	private String tomatoAppid;
	@Value("${tomato.wechat.official.account.secret}")
	private String tomatoSecret;
	@Value("${playabc.wechat.official.account.appid}")
	private String playabcAppid;
	@Value("${playabc.wechat.official.account.secret}")
	private String playabcSecret;
	@Value("${guanmei.wechat.official.account.appid}")
	private String guanmeiAppid;
	@Value("${guanmei.wechat.official.account.secret}")
	private String guanmeiSecret;

	/** 获取微信公众号账户信息 */
	public static WechatOffiaccount getWechatOffiaccount(BrandEnum brand) {
		if (BrandEnum.tomato == brand)
			return WechatOffiaccount.of(_this.tomatoAppid, _this.tomatoSecret);
		if (BrandEnum.playabc == brand)
			return WechatOffiaccount.of(_this.playabcAppid, _this.playabcSecret);
		if (BrandEnum.guanmei == brand)
			return WechatOffiaccount.of(_this.guanmeiAppid, _this.guanmeiSecret);
		return null;
	}
}
