package com.jz.jar.business.wrapper;

import java.util.List;

import com.jz.jar.business.bean.AliyunBean;
import com.jz.jooq.media.tables.pojos.TomatoCourseAi;

public class TomatoCourseAiWrapper {

	private String aid;
	private String name;
	private String homework;
	private String pic;
	private String teacher;

	// 课包属性
	private Boolean isFree;
	private String pid;
	private Integer learnStatus; // 学习状态
	private Boolean locked;

	// ai课详情属性
	private Boolean videoFinish; // 是否已完成本ai全部视频的学习
	private List<TomatoCourseAiPartWrapper> parts;

	public static TomatoCourseAiWrapper of(TomatoCourseAi a, int type) {
		return new TomatoCourseAiWrapper().setAid(a.getAid()).setName(a.getName()).setHomework(a.getHomework())
				.setPic(a.getPic()).setTeacher(a.getTeacher()).setIsFree(type == 0); // 0免费1付费
	}

	public Integer getLearnStatus() {
		return learnStatus;
	}

	public TomatoCourseAiWrapper setLearnStatus(Integer learnStatus) {
		this.learnStatus = learnStatus;
		return this;
	}

	public Boolean getIsFree() {
		return isFree;
	}

	public TomatoCourseAiWrapper setIsFree(Boolean isFree) {
		this.isFree = isFree;
		return this;
	}

	public String getPid() {
		return pid;
	}

	public TomatoCourseAiWrapper setPid(String pid) {
		this.pid = pid;
		return this;
	}

	public String getAid() {
		return aid;
	}

	public TomatoCourseAiWrapper setAid(String aid) {
		this.aid = aid;
		return this;
	}

	public String getName() {
		return name;
	}

	public TomatoCourseAiWrapper setName(String name) {
		this.name = name;
		return this;
	}

	public String getHomework() {
		return homework;
	}

	public TomatoCourseAiWrapper setHomework(String homework) {
		this.homework = homework;
		return this;
	}

	public String getPic() {
		return pic;
	}

	public TomatoCourseAiWrapper setPic(String pic) {
		this.pic = AliyunBean.getImagesUrl(pic);
		return this;
	}

	public Boolean getLocked() {
		return locked;
	}

	public TomatoCourseAiWrapper setLocked(Boolean locked) {
		this.locked = locked;
		return this;
	}

	public Boolean getVideoFinish() {
		return videoFinish;
	}

	public TomatoCourseAiWrapper setVideoFinish(Boolean videoFinish) {
		this.videoFinish = videoFinish;
		return this;
	}

	public List<TomatoCourseAiPartWrapper> getParts() {
		return parts;
	}

	public TomatoCourseAiWrapper setParts(List<TomatoCourseAiPartWrapper> parts) {
		this.parts = parts;
		return this;
	}

	public String getTeacher() {
		return teacher;
	}

	public TomatoCourseAiWrapper setTeacher(String teacher) {
		this.teacher = teacher;
		return this;
	}

}
