package com.jz.jar.business.card;

import com.jz.jar.business.wrapper.LiveSimpleWrapper;
import com.jz.jar.business.wrapper.TomatoCourseVideoWrapper;

public class CpItemCard {

	private CpItemCard(String type) {
		this.setType(type);
	}

	private String type;

	private TomatoCourseVideoWrapper video;
	private LiveSimpleWrapper live;

	public static CpItemCard of(TomatoCourseVideoWrapper video) {
		return new CpItemCard("video").setVideo(video);
	}

	public static CpItemCard of(LiveSimpleWrapper live) {
		return new CpItemCard("live").setLive(live);
	}

	public String getType() {
		return type;
	}

	public CpItemCard setType(String type) {
		this.type = type;
		return this;
	}

	public TomatoCourseVideoWrapper getVideo() {
		return video;
	}

	public CpItemCard setVideo(TomatoCourseVideoWrapper video) {
		this.video = video;
		return this;
	}

	public LiveSimpleWrapper getLive() {
		return live;
	}

	public CpItemCard setLive(LiveSimpleWrapper live) {
		this.live = live;
		return this;
	}

}
