package com.jz.jar.business.wrapper;

import java.io.Serializable;

import com.jz.jar.media.enums.BrandEnum;
import com.jz.jooq.franchise.tables.pojos.CourseTomatoPlanOs;
import com.jz.jooq.media.tables.pojos.MediaVideo;
import com.jz.jooq.media.tables.pojos.TomatoCourseVideo;
import com.jz.jooq.media.tables.pojos.UploadVideo;

/**
 * @Title VideoWrapper
 * @Package com.jz.playabc.api.wrapper
 * @author tangjunfeng
 * @date 2018年8月1日 下午5:27:58
 * @version V1.0
 */
@SuppressWarnings("serial")
public class VideoWrapper implements Cloneable, Serializable {
	private VideoWrapper() {
	}

	// 视频信息
	private String wid;
	private String name;
	private String content;
	private String goal;
	private String homework;
	private Boolean isFree;
	private String dar;
	private Integer duration;
	private String hd;
	private String normal;
	private String low;
	private String audit;
	private String snapshotUrl;
	private Long createTime;
	private Long lastUpdate;

	// 播放数，收藏数
	private Integer watchCnt;
	private Integer collectCnt;

	// 专辑id
	private String pid;

	// 集数名字
	private String episodeName;
	// 当前集数
	private Boolean isSelf;
	// 包含分享
	private Boolean withShare;
	// 包含收藏
	private Boolean withCollect;

	// 是否收藏
	private Boolean isCollect;

	// 上次播放时长
	private Integer playLength;

	// 学习进度
	private Integer maxPlayLength;

	/* 上传视频相关 */
	private String uid;
	private Integer status;

	private Integer score; // 评分
	private String remark; // 评语

	public static VideoWrapper of(MediaVideo video) {
		VideoWrapper wrapper = new VideoWrapper().setWid(video.getWid()).setName(video.getName())
				.setDar(video.getDar()).setDuration(video.getDuration()).setCreateTime(video.getCreateTime())
				.setLastUpdate(video.getLastUpdate()).setWatchCnt(video.getWatchCnt());
		video.getWatchCnt();
		// 补课视频不能分享及收藏
		if (BrandEnum.playabc.name().equals(video.getBrand()))
			wrapper.setWithShare(false).setWithCollect(false);
		return wrapper;
	}

	public static VideoWrapper of(UploadVideo video) {
		VideoWrapper wrapper = new VideoWrapper().setWid(video.getWid()).setName(video.getName())
				.setDar(video.getDar()).setDuration(video.getDuration()).setCreateTime(video.getCreateTime())
				.setLastUpdate(video.getLastUpdate()).setWithShare(true).setWithCollect(false).setUid(video.getUid())
				.setStatus(video.getStatus());
		return wrapper;
	}

	public static VideoWrapper of(CourseTomatoPlanOs video) {
		VideoWrapper wrapper = new VideoWrapper().setWid(video.getWid()).setDuration(video.getDuration())
				.setCreateTime(video.getCreateTime()).setStatus(video.getStatus());
		return wrapper;
	}

	public static VideoWrapper of(TomatoCourseVideo video) {
		VideoWrapper wrapper = new VideoWrapper().setWid(video.getWid()).setDuration(video.getDuration())
				.setCreateTime(video.getCreateTime()).setStatus(video.getStatus());
		return wrapper;
	}

	public String getWid() {
		return wid;
	}

	public VideoWrapper setWid(String wid) {
		this.wid = wid;
		return this;
	}

	public String getName() {
		return name;
	}

	public VideoWrapper setName(String name) {
		this.name = name;
		return this;
	}

	public String getDar() {
		return dar;
	}

	public VideoWrapper setDar(String dar) {
		this.dar = dar;
		return this;
	}

	public Integer getDuration() {
		return duration;
	}

	public VideoWrapper setDuration(Integer duration) {
		this.duration = duration;
		return this;
	}

	public String getHd() {
		return hd;
	}

	public VideoWrapper setHd(String hd) {
		this.hd = hd;
		return this;
	}

	public String getNormal() {
		return normal;
	}

	public VideoWrapper setNormal(String normal) {
		this.normal = normal;
		return this;
	}

	public String getLow() {
		return low;
	}

	public VideoWrapper setLow(String low) {
		this.low = low;
		return this;
	}

	public String getAudit() {
		return audit;
	}

	public VideoWrapper setAudit(String audit) {
		this.audit = audit;
		return this;
	}

	public String getSnapshotUrl() {
		return snapshotUrl;
	}

	public VideoWrapper setSnapshotUrl(String snapshotUrl) {
		this.snapshotUrl = snapshotUrl;
		return this;
	}

	public Long getCreateTime() {
		return createTime;
	}

	public VideoWrapper setCreateTime(Long createTime) {
		this.createTime = createTime;
		return this;
	}

	public Long getLastUpdate() {
		return lastUpdate;
	}

	public VideoWrapper setLastUpdate(Long lastUpdate) {
		this.lastUpdate = lastUpdate;
		return this;
	}

	public Integer getWatchCnt() {
		return watchCnt;
	}

	public VideoWrapper setWatchCnt(Integer watchCnt) {
		this.watchCnt = watchCnt;
		return this;
	}

	public Integer getCollectCnt() {
		return collectCnt;
	}

	public VideoWrapper setCollectCnt(Integer collectCnt) {
		this.collectCnt = collectCnt;
		return this;
	}

	public String getPid() {
		return pid;
	}

	public VideoWrapper setPid(String pid) {
		this.pid = pid;
		return this;
	}

	public String getEpisodeName() {
		return episodeName;
	}

	public VideoWrapper setEpisodeName(String episodeName) {
		this.episodeName = episodeName;
		return this;
	}

	public Boolean getIsSelf() {
		return isSelf;
	}

	public VideoWrapper setIsSelf(Boolean isSelf) {
		this.isSelf = isSelf;
		return this;
	}

	public Boolean getWithShare() {
		return withShare;
	}

	public VideoWrapper setWithShare(Boolean withShare) {
		this.withShare = withShare;
		return this;
	}

	public Boolean getWithCollect() {
		return withCollect;
	}

	public VideoWrapper setWithCollect(Boolean withCollect) {
		this.withCollect = withCollect;
		return this;
	}

	public Integer getPlayLength() {
		return playLength;
	}

	public VideoWrapper setPlayLength(Integer playLength) {
		this.playLength = playLength;
		return this;
	}

	public String getUid() {
		return uid;
	}

	public VideoWrapper setUid(String uid) {
		this.uid = uid;
		return this;
	}

	public Integer getStatus() {
		return status;
	}

	public VideoWrapper setStatus(Integer status) {
		this.status = status;
		return this;
	}

	public Boolean getIsCollect() {
		return isCollect;
	}

	public VideoWrapper setIsCollect(Boolean isCollect) {
		this.isCollect = isCollect;
		return this;
	}

	@Override
	public VideoWrapper clone() {
		try {
			return (VideoWrapper) super.clone();
		} catch (CloneNotSupportedException e) {
			return this;
		}
	}

	public Integer getScore() {
		return score;
	}

	public VideoWrapper setScore(Integer score) {
		this.score = score;
		return this;
	}

	public String getRemark() {
		return remark;
	}

	public VideoWrapper setRemark(String remark) {
		this.remark = remark;
		return this;
	}

	public Integer getMaxPlayLength() {
		return maxPlayLength;
	}

	public VideoWrapper setMaxPlayLength(Integer maxPlayLength) {
		this.maxPlayLength = maxPlayLength;
		return this;
	}

	public String getContent() {
		return content;
	}

	public VideoWrapper setContent(String content) {
		this.content = content;
		return this;
	}

	public String getGoal() {
		return goal;
	}

	public VideoWrapper setGoal(String goal) {
		this.goal = goal;
		return this;
	}

	public String getHomework() {
		return homework;
	}

	public VideoWrapper setHomework(String homework) {
		this.homework = homework;
		return this;
	}

	public Boolean getIsFree() {
		return isFree;
	}

	public VideoWrapper setIsFree(Boolean isFree) {
		this.isFree = isFree;
		return this;
	}

}
