package com.jz.jar.business.wrapper;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.jz.jooq.website.tables.pojos.NewsInfo;

/**
 * @Title NewsInfoWrapper
 * @Package com.jz.jar.common.wrapper
 * @author tangjunfeng
 * @date 2019年1月23日 下午4:49:31
 * @version V1.0
 */
public class NewsInfoWrapper {

	private String id;
	private String title;
	private String pic;
	private String content;
	private Long createTime;

	private String schoolName;
	private String schoolId;

	private NewsInfoWrapper() {
	}

	public static NewsInfoWrapper of(NewsInfo newsInfo) {
		return new NewsInfoWrapper().setId(newsInfo.getId()).setTitle(newsInfo.getTitle()).setPic(newsInfo.getPic())
				.setContent(newsInfo.getContent()).setSchoolId(newsInfo.getSchoolId())
				.setCreateTime(newsInfo.getCreateTime());
	}

	public String getId() {
		return id;
	}

	public NewsInfoWrapper setId(String id) {
		this.id = id;
		return this;
	}

	public String getTitle() {
		return title;
	}

	public NewsInfoWrapper setTitle(String title) {
		this.title = title;
		return this;
	}

	public String getPic() {
		return pic;
	}

	public NewsInfoWrapper setPic(String pic) {
		this.pic = pic;
		return this;
	}

	public String getContent() {
		return content;
	}

	public NewsInfoWrapper setContent(String content) {
		this.content = content;
		return this;
	}

	public Long getCreateTime() {
		return createTime;
	}

	public NewsInfoWrapper setCreateTime(Long createTime) {
		this.createTime = createTime;
		return this;
	}

	public String getSchoolName() {
		return schoolName;
	}

	public NewsInfoWrapper setSchoolName(String schoolName) {
		this.schoolName = schoolName;
		return this;
	}

	@JsonIgnore
	public String getSchoolId() {
		return schoolId;
	}

	public NewsInfoWrapper setSchoolId(String schoolId) {
		this.schoolId = schoolId;
		return this;
	}

}
