package com.jz.jar.business.request;

import java.util.Collection;

public class TomatoCoursePackRequest {
	private TomatoCoursePackRequest() {
	}

	private Collection<String> pids;
	private boolean keepOrder = false;
	private boolean withFinishCnt = false;
	private String suid;

	public static TomatoCoursePackRequest of(Collection<String> pids) {
		return new TomatoCoursePackRequest().setPids(pids);
	}

	public Collection<String> getPids() {
		return pids;
	}

	public TomatoCoursePackRequest setPids(Collection<String> pids) {
		this.pids = pids;
		return this;
	}

	public boolean isKeepOrder() {
		return keepOrder;
	}

	public TomatoCoursePackRequest setKeepOrder(boolean keepOrder) {
		this.keepOrder = keepOrder;
		return this;
	}

	public boolean isWithFinishCnt() {
		return withFinishCnt;
	}

	public TomatoCoursePackRequest setWithFinishCnt(boolean withFinishCnt) {
		this.withFinishCnt = withFinishCnt;
		return this;
	}

	public String getSuid() {
		return suid;
	}

	public TomatoCoursePackRequest setSuid(String suid) {
		this.suid = suid;
		return this;
	}

}
