package com.jz.jar.business.proxy.common;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

import com.jz.jar.business.wrapper.TagWrapper;
import com.jz.jar.media.service.TomatoTagService;

@Lazy
@Service
public class TomatoTagProxy {

	@Autowired
	private TomatoTagService tomatoTagService;

	public List<TagWrapper> listTags() {
		return tomatoTagService.listTags().stream().map(t -> TagWrapper.of(t)).collect(Collectors.toList());
	}

	public List<TagWrapper> mutiGetTags(Collection<String> tids) {
		return tomatoTagService.mutiGetTags(tids).stream().map(t -> TagWrapper.of(t)).collect(Collectors.toList());
	}

	public Map<String, TagWrapper> mutiGetTagMap(Collection<String> tids) {
		return this.mutiGetTags(tids).stream().collect(Collectors.toMap(t -> t.getTid(), t -> t));
	}

}