/*
 * Decompiled with CFR 0.152.
 */
package com.jz.jar.search.service;

import com.aliyun.opensearch.DocumentClient;
import com.aliyun.opensearch.OpenSearchClient;
import com.aliyun.opensearch.SearcherClient;
import com.aliyun.opensearch.sdk.generated.OpenSearch;
import com.aliyun.opensearch.sdk.generated.commons.OpenSearchClientException;
import com.aliyun.opensearch.sdk.generated.commons.OpenSearchException;
import com.aliyun.opensearch.sdk.generated.commons.OpenSearchResult;
import com.aliyun.opensearch.sdk.generated.document.Command;
import com.aliyun.opensearch.sdk.generated.search.Config;
import com.aliyun.opensearch.sdk.generated.search.Order;
import com.aliyun.opensearch.sdk.generated.search.SearchFormat;
import com.aliyun.opensearch.sdk.generated.search.SearchParams;
import com.aliyun.opensearch.sdk.generated.search.Sort;
import com.aliyun.opensearch.sdk.generated.search.SortField;
import com.aliyun.opensearch.sdk.generated.search.general.SearchResult;
import com.google.common.collect.Lists;
import com.google.gson.reflect.TypeToken;
import com.jz.common.utils.collection.ArrayMapTools;
import com.jz.common.utils.json.GsonTools;
import com.jz.common.utils.text.StringTools;
import com.jz.jar.media.enums.PlaylistType;
import com.jz.jar.search.entity.business.tomato.ETomatoSearchBean;
import com.jz.jar.search.entity.business.tomato.TomatoSearchType;
import com.jz.jar.search.entity.push.AliOpenSearchPushTemplate;
import com.jz.jar.search.entity.result.AliOpenSearchBaseResult;
import com.jz.jar.search.entity.result.AliOpenSearchResult;
import com.jz.jar.search.service.AbstractOpenSearchService;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@Lazy
@Service
public class TomatoSearchService
extends AbstractOpenSearchService {
    private static Logger logger = LoggerFactory.getLogger(TomatoSearchService.class);
    @Value(value="${aliyun.open.search.tomato.app.name}")
    private String appName;
    @Value(value="${aliyun.open.search.tomato.table.name}")
    private String tableName;
    private static Config config;
    private static final Type type;

    @PostConstruct
    public void init() {
        config = new Config((List)Lists.newArrayList((Object[])new String[]{this.appName}));
        config.setSearchFormat(SearchFormat.JSON);
        config.setFetchFields((List)Lists.newArrayList((Object[])new String[]{"id", "type"}));
    }

    public AliOpenSearchResult<ETomatoSearchBean> search(String name, PlaylistType filterType, Collection<String> attrs, int start, int size) throws OpenSearchException, OpenSearchClientException {
        SearcherClient searcherClient = new SearcherClient(this.openSearchClient);
        config.setStart(start).setHits(size);
        SearchParams searchParams = new SearchParams(config);
        if (StringTools.isNotEmptyAndBlank((String)name)) {
            searchParams.setQuery("name:'" + name + "'");
        }
        StringBuffer filter = new StringBuffer();
        if (null != filterType) {
            filter.append("in(type, \"");
            if (PlaylistType.video == filterType) {
                filter.append(TomatoSearchType.getVideoCode("|"));
            } else {
                filter.append(TomatoSearchType.getImageTxtCode("|"));
            }
            filter.append("\")");
        }
        if (ArrayMapTools.isNotEmpty(attrs)) {
            if (filter.length() > 0) {
                filter.append(" AND ");
            }
            for (String attrId : attrs) {
                filter.append("attrs=\"").append(attrId).append("\"").append(" AND ");
            }
            filter.delete(filter.length() - 5, filter.length());
        }
        if (filter.length() > 0) {
            searchParams.setFilter(filter.toString());
        }
        Sort sorter = new Sort();
        sorter.addToSortFields(new SortField("type", Order.INCREASE));
        sorter.addToSortFields(new SortField("timer", Order.DECREASE));
        sorter.addToSortFields(new SortField("RANK", Order.DECREASE));
        searchParams.setSort(sorter);
        SearchResult searchResult = searcherClient.execute(searchParams);
        AliOpenSearchBaseResult gsonResult = (AliOpenSearchBaseResult)GsonTools.gson.fromJson(searchResult.getResult(), type);
        return gsonResult.getResult();
    }

    public boolean searchPushCommand(List<AliOpenSearchPushTemplate<ETomatoSearchBean>> pojos) {
        if (ArrayMapTools.isEmpty(pojos)) {
            return true;
        }
        return this.searchPushCommand(GsonTools.gson.toJson(pojos));
    }

    @Override
    public boolean searchPushCommand(String docs) {
        if (StringTools.isEmpty((CharSequence)docs)) {
            return true;
        }
        DocumentClient documentClient = new DocumentClient(this.openSearchClient);
        try {
            OpenSearchResult osr = documentClient.push(docs, this.appName, this.tableName);
            if (osr.getResult().equalsIgnoreCase("true")) {
                return true;
            }
            logger.error("add doc failed, infos : {}, result : {}", (Object)docs, (Object)osr.getResult());
        }
        catch (OpenSearchClientException | OpenSearchException e) {
            logger.error(e.getMessage(), e);
        }
        logger.error("\u66f4\u65b0\u756a\u8304\u7530\u641c\u7d22\u5185\u5bb9\u5931\u8d25\uff1a\n" + docs);
        throw new RuntimeException("\u66f4\u65b0\u756a\u8304\u7530\u641c\u7d22\u5185\u5bb9\u5931\u8d25");
    }

    public static void main(String[] args) throws OpenSearchException, OpenSearchClientException {
        TomatoSearchService ts = new TomatoSearchService();
        ts.appName = "tomato_app_test";
        ts.tableName = "tomato_context_resources";
        ts.init();
        String accessKeyId = "LTAIXIOV1fsWtqzM";
        String accessKeySecret = "aEnYKzdq9wZS5MLrJw6Dj8amkW3XK9";
        String host = "http://opensearch-cn-beijing.aliyuncs.com";
        OpenSearch openSearch = new OpenSearch(accessKeyId, accessKeySecret, host);
        ts.openSearchClient = new OpenSearchClient(openSearch);
        ArrayList pojos = Lists.newArrayList();
        pojos.add(AliOpenSearchPushTemplate.of(Command.DELETE, new ETomatoSearchBean().setId("ystllvtx4yn0ekm6").setName("\u5343\u5c9b\u4e4b\u56fd\u7684\u795e\u79d8\u97f3\u753b").setTimer(1560218508337L).setAttrs(Arrays.asList("aa", "hh", "xx", "T1", "T2")).setType(TomatoSearchType.video_playlist)));
        pojos.add(AliOpenSearchPushTemplate.of(Command.DELETE, new ETomatoSearchBean().setId("xx_imt").setName("\u997f\u6b7b\u6211\u7b97\u5566").setTimer(0L).setAttrs(Arrays.asList("aa", "hh", "T1", "T2")).setType(TomatoSearchType.img_txt_playlist)));
        pojos.add(AliOpenSearchPushTemplate.of(Command.DELETE, new ETomatoSearchBean().setId("uy56unuxsissgqql").setName("\u91d1\u521a\u846b\u82a6\u5a03").setTimer(1560218528337L).setAttrs(Arrays.asList("hh", "xx", "T1", "T2")).setType(TomatoSearchType.video_playlist)));
        pojos.add(AliOpenSearchPushTemplate.of(Command.DELETE, new ETomatoSearchBean().setId("xha4bu1wl1vd03es").setName("\u798f\u7984\u5c0f\u91d1\u521a").setTimer(1560218838337L).setAttrs(Arrays.asList("xx", "T1", "T2")).setType(TomatoSearchType.video_playlist)));
        pojos.add(AliOpenSearchPushTemplate.of(Command.DELETE, new ETomatoSearchBean().setId("1").setName("\u53d8\u6001\u5c0f\u8fa3\u6912").setTimer(1560218508737L).setAttrs(Arrays.asList("aa", "T1", "T2")).setType(TomatoSearchType.img_txt)));
        pojos.add(AliOpenSearchPushTemplate.of(Command.DELETE, new ETomatoSearchBean().setId("2").setName("\u8fa3\u6912\u5c0f\u53d8\u6001").setTimer(1560218505337L).setAttrs(Arrays.asList("hh", "aa", "T1", "T2")).setType(TomatoSearchType.img_txt)));
        pojos.add(AliOpenSearchPushTemplate.of(Command.DELETE, new ETomatoSearchBean().setId("99e196f0c26fc1a6cf").setName("\u5c0f\u5c0f\u8fa3\u6912").setTimer(1560218505337L).setAttrs(Arrays.asList("aa", "xx", "T1", "T2")).setType(TomatoSearchType.video)));
        pojos.add(AliOpenSearchPushTemplate.of(Command.DELETE, new ETomatoSearchBean().setId("99ef6a664f8d520138").setName("\u5c0f\u96cd\u548c\u5bab\u5927\u548c\u5c1a").setTimer(1560218505337L).setAttrs(Arrays.asList("aa", "xx", "T1", "T2")).setType(TomatoSearchType.video)));
        pojos.add(AliOpenSearchPushTemplate.of(Command.DELETE, new ETomatoSearchBean().setId("99f4b53a68d9005634").setName("\u4e00\u4e0d\u5c0f\u5fc3\u4e0d\u89c1\u5566").setTimer(1560218505337L).setAttrs(Arrays.asList("hh", "xx", "T1", "T2")).setType(TomatoSearchType.video)));
        System.out.println("result : " + ts.searchPushCommand(pojos));
        System.out.println("result : " + GsonTools.gson.toJson(ts.search(null, PlaylistType.img_txt, null, 0, 5)));
    }

    static {
        type = new TypeToken<AliOpenSearchBaseResult<ETomatoSearchBean>>(){}.getType();
    }
}

