package com.jz.jar.business.proxy.common;

import java.util.Collection;
import java.util.List;
import java.util.Map;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

import com.google.common.collect.Maps;
import com.jz.common.utils.collection.ArrayMapTools;
import com.jz.jar.business.enums.TomatoEnum;
import com.jz.jar.business.wrapper.WTomatoAttribute;
import com.jz.jar.media.service.TomatoAttributesService;
import com.jz.jar.media.service.TomatoPlaylistAttributesService;
import com.jz.jooq.media.tables.pojos.TomatoAttributes;

/**
 * @Title PlaylistAttributesProxy
 * @Package com.jz.jar.business.proxy.common
 * @author tangjunfeng
 * @date 2019年6月11日 上午11:22:36
 * @version V1.0
 */
@Lazy
@Service
public class AttributesProxy {

	@Autowired
	private TomatoPlaylistAttributesService playlistAttributesService;
	@Autowired
	private TomatoAttributesService tomatoAttributesService;

	private Collection<WTomatoAttribute> packageAttribute(List<TomatoAttributes> attributes) {
		if (ArrayMapTools.isEmpty(attributes))
			return null;
		Map<TomatoEnum, WTomatoAttribute> has = Maps.newHashMap();
		attributes.forEach(_ta -> {
			TomatoEnum te = TomatoEnum.valueOf(_ta.getClassify());
			if (te == null || te == TomatoEnum.age)
				return; // 不展示年龄
			if (!has.containsKey(te))
				has.put(te, WTomatoAttribute.of(te));
			has.get(te).addChild(WTomatoAttribute.of(_ta));
		});
		return has.values();
	}

	public Collection<WTomatoAttribute> getPlaylistAttributes(Collection<String> pids) {
		List<String> attributes = playlistAttributesService.findAttributeIds(pids);
		if (ArrayMapTools.isEmpty(attributes))
			return null;
		return packageAttribute(tomatoAttributesService.findAttributes(attributes));
	}

	public Collection<WTomatoAttribute> getAttributes() {
		return packageAttribute(tomatoAttributesService.findAllAttributes());
	}

}
