/*
 * Decompiled with CFR 0.152.
 */
package com.jz.aliyun.tools;

import com.aliyun.oss.ClientConfiguration;
import com.aliyun.oss.OSSClient;
import com.aliyun.oss.model.CannedAccessControlList;
import com.aliyun.oss.model.CopyObjectRequest;
import com.aliyun.oss.model.ListObjectsRequest;
import com.aliyun.oss.model.OSSObjectSummary;
import com.aliyun.oss.model.ObjectListing;
import com.aliyun.oss.model.ObjectMetadata;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.jz.aliyun.beans.AliyunConfig;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OssTools {
    private static final Logger logger = LoggerFactory.getLogger(OssTools.class);
    private AliyunConfig aliyunConfig;

    private OssTools() {
    }

    private OssTools(AliyunConfig aliyunConfig) {
        this.aliyunConfig = aliyunConfig;
    }

    public static OssTools getInstance(AliyunConfig aliyunConfig) {
        return new OssTools(aliyunConfig);
    }

    public void upload(String localFilePath, String ossFilePath) throws FileNotFoundException {
        logger.info("aliyun upload file : {} => {}", (Object)localFilePath, (Object)ossFilePath);
        this.upload(new FileInputStream(new File(localFilePath)), ossFilePath);
    }

    private OSSClient getOssClient() {
        ClientConfiguration conf = new ClientConfiguration();
        conf.setSupportCname(true);
        return new OSSClient(this.aliyunConfig.getEndpoint(), this.aliyunConfig.getAccessKeyId(), this.aliyunConfig.getAccessKeySecret(), conf);
    }

    public void upload(InputStream inputStream, String ossFilePath) throws FileNotFoundException {
        OSSClient ossClient = this.getOssClient();
        ossClient.putObject(this.aliyunConfig.getBucketName(), ossFilePath, inputStream);
        ossClient.shutdown();
    }

    public void copy(String sourcePath, String destinationPath) {
        logger.info("aliyun copy file : {} => {}", (Object)sourcePath, (Object)destinationPath);
        OSSClient ossClient = this.getOssClient();
        ossClient.copyObject(this.aliyunConfig.getBucketName(), sourcePath, this.aliyunConfig.getBucketName(), destinationPath);
        ossClient.shutdown();
    }

    public void copyToTargetBucket(String sourcePath, String destinationPath) {
        logger.info("aliyun copy file : {}.{} => {}.{}", new Object[]{this.aliyunConfig.getSourceBucketName(), sourcePath, this.aliyunConfig.getTargetBucketName(), destinationPath});
        OSSClient ossClient = this.getOssClient();
        ossClient.copyObject(this.aliyunConfig.getSourceBucketName(), sourcePath, this.aliyunConfig.getTargetBucketName(), destinationPath);
        ossClient.setObjectAcl(this.aliyunConfig.getTargetBucketName(), destinationPath, CannedAccessControlList.Default);
        ossClient.shutdown();
    }

    public void delete(String filePath) throws FileNotFoundException {
        logger.info("aliyun delete file : {} => {}", (Object)this.aliyunConfig.getBucketName(), (Object)filePath);
        OSSClient ossClient = this.getOssClient();
        ossClient.deleteObject(this.aliyunConfig.getBucketName(), filePath);
        ossClient.shutdown();
    }

    public void move(String sourcePath, String destinationPath) {
        logger.info("aliyun mv file : {}/{} => {}/{}", new Object[]{this.aliyunConfig.getSourceBucketName(), sourcePath, this.aliyunConfig.getTargetBucketName(), destinationPath});
        OSSClient ossClient = this.getOssClient();
        ossClient.copyObject(this.aliyunConfig.getSourceBucketName(), sourcePath, this.aliyunConfig.getTargetBucketName(), destinationPath);
        ossClient.setObjectAcl(this.aliyunConfig.getTargetBucketName(), destinationPath, CannedAccessControlList.Default);
        ossClient.deleteObject(this.aliyunConfig.getSourceBucketName(), sourcePath);
        ossClient.shutdown();
    }

    public String getUrl(String fileUrl, int expireSeconds) {
        OSSClient ossClient = this.getOssClient();
        Calendar expiration = Calendar.getInstance();
        expiration.add(13, expireSeconds);
        URL url = ossClient.generatePresignedUrl(this.aliyunConfig.getBucketName(), fileUrl, expiration.getTime());
        ossClient.shutdown();
        return url.toString();
    }

    public Map<String, String> getUrl(Collection<String> fileUrls, int expireSeconds) {
        OSSClient ossClient = this.getOssClient();
        Calendar expiration = Calendar.getInstance();
        expiration.add(13, expireSeconds);
        HashMap source2Target = Maps.newHashMap();
        for (String tempUrl : fileUrls) {
            URL url = ossClient.generatePresignedUrl(this.aliyunConfig.getBucketName(), tempUrl, expiration.getTime());
            source2Target.put(tempUrl, url.toString());
        }
        ossClient.shutdown();
        return source2Target;
    }

    public void updateDownloadName(String sourcePath, String downloadFileName) throws UnsupportedEncodingException {
        logger.info("aliyun update download file name : {} => {}", (Object)sourcePath, (Object)downloadFileName);
        OSSClient ossClient = this.getOssClient();
        String bucketName = this.aliyunConfig.getSourceBucketName();
        CopyObjectRequest request = new CopyObjectRequest(bucketName, sourcePath, bucketName, sourcePath);
        ObjectMetadata meta = new ObjectMetadata();
        meta.setContentDisposition("attachment; filename=" + URLEncoder.encode(downloadFileName, "UTF-8"));
        meta.setContentEncoding("UTF-8");
        request.setNewObjectMetadata(meta);
        ossClient.copyObject(request);
        ossClient.shutdown();
    }

    public List<String> listFiles(String filePath) {
        OSSClient ossClient = this.getOssClient();
        int maxKeys = 200;
        ObjectListing objectListing = ossClient.listObjects(new ListObjectsRequest(this.aliyunConfig.getBucketName()).withPrefix(filePath).withMaxKeys(Integer.valueOf(200)));
        List sums = objectListing.getObjectSummaries();
        ArrayList list = Lists.newArrayList();
        for (OSSObjectSummary s : sums) {
            list.add(s.getKey());
        }
        ossClient.shutdown();
        return list;
    }

    public long getFileSizeByte(String filePath) {
        OSSClient ossClient = this.getOssClient();
        return ossClient.getObject(this.aliyunConfig.getBucketName(), filePath).getObjectMetadata().getContentLength();
    }

    public static void main(String[] args) {
        String filePath = "playabc/cms/test/5hw53q1i7snd8bcg.png";
        AliyunConfig config = AliyunConfig.of("oss-cn-beijing.aliyuncs.com", "LTAIXIOV1fsWtqzM", "aEnYKzdq9wZS5MLrJw6Dj8amkW3XK9", "jz-images");
        System.out.println(OssTools.getInstance(config).getFileSizeByte(filePath));
    }
}

