/*
 * Decompiled with CFR 0.152.
 */
package com.gymchina.pay.client;

import com.google.common.collect.Maps;
import com.gymchina.bean.response.GymchinaPayCommonResponse;
import com.gymchina.bean.tools.PaymentHttpTool;
import com.gymchina.pay.client.configuration.GymchinaPayClientConfiguration;
import com.gymchina.pay.client.request.IRequest;
import com.jz.common.utils.http.ConnectPost;
import com.jz.common.utils.json.GsonTools;
import com.jz.common.utils.text.StringTools;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.beanutils.BeanUtils;

public class PayClient {
    private String payUrl;
    private String signKey;
    private String utf8 = "utf-8";
    private boolean showLog;

    private PayClient(String payUrl, String signKey, boolean showLog) {
        this.payUrl = payUrl;
        this.signKey = signKey;
        this.showLog = showLog;
    }

    public static PayClient getClient(String payUrl, String signKey, boolean showLog) {
        if (!StringTools.startsWithAny((CharSequence)payUrl, (CharSequence[])new CharSequence[]{"http://", "https://"})) {
            throw new IllegalArgumentException("invalid pay url");
        }
        return new PayClient(payUrl, signKey, showLog);
    }

    public static PayClient getClient(String payUrl, String signKey) {
        return PayClient.getClient(payUrl, signKey, false);
    }

    public static PayClient getClient() {
        return PayClient.getClient(GymchinaPayClientConfiguration.getPayServer(), GymchinaPayClientConfiguration.getSignKey());
    }

    public GymchinaPayCommonResponse invokeGymchinaPay(IRequest request) throws Exception {
        Map<String, String> param = this.getParam(request);
        param.put("sign", PaymentHttpTool.getGymchinaPayParamSign(param, (String)this.signKey));
        String url = this.getRequestUrl(request.mapping());
        String result = ConnectPost.send((String)url, param, (String)this.utf8, (boolean)this.showLog);
        if (null == result) {
            return null;
        }
        return (GymchinaPayCommonResponse)GsonTools.gson.fromJson(result, GymchinaPayCommonResponse.class);
    }

    private Map<String, String> getParam(IRequest request) throws Exception {
        HashMap has = Maps.newHashMap();
        String value = null;
        for (Field field : request.getClass().getDeclaredFields()) {
            value = BeanUtils.getSimpleProperty((Object)request, (String)field.getName());
            if (null == value) continue;
            has.put(field.getName(), value);
        }
        return has;
    }

    private String getRequestUrl(String mapping) {
        if (mapping.startsWith("/")) {
            mapping = mapping.substring(1);
        }
        if (this.payUrl.endsWith("/")) {
            return this.payUrl + mapping;
        }
        return this.payUrl + "/" + mapping;
    }
}

