/*
 * Decompiled with CFR 0.152.
 */
package com.gymchina.bean.tools;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.security.KeyStore;
import javax.net.ssl.SSLContext;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.ssl.SSLContexts;
import org.apache.http.util.EntityUtils;

public class WechatSSLConnectPost {
    private static final String pkcs12 = "PKCS12";
    private static final String utf8 = "UTF-8";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String sendBody(String url, String body, String p12Path, String certPwd) throws Exception {
        KeyStore keyStore = KeyStore.getInstance(pkcs12);
        char[] password = certPwd.toCharArray();
        try (FileInputStream instream = new FileInputStream(new File(p12Path));){
            keyStore.load(instream, password);
        }
        StringBuffer result = new StringBuffer();
        SSLContext sslcontext = SSLContexts.custom().loadKeyMaterial(keyStore, password).build();
        SSLConnectionSocketFactory sslsf = new SSLConnectionSocketFactory(sslcontext);
        try (CloseableHttpClient httpclient = HttpClients.custom().setSSLSocketFactory((LayeredConnectionSocketFactory)sslsf).build();){
            HttpPost httpPost = new HttpPost(url);
            StringEntity reqEntity = new StringEntity(body, Charset.forName(utf8));
            reqEntity.setContentType("application/x-www-form-urlencoded");
            httpPost.setEntity((HttpEntity)reqEntity);
            try (CloseableHttpResponse response = httpclient.execute((HttpUriRequest)httpPost);){
                HttpEntity entity = response.getEntity();
                if (entity != null) {
                    String text;
                    BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(entity.getContent(), utf8));
                    while ((text = bufferedReader.readLine()) != null) {
                        result.append(text);
                    }
                }
                EntityUtils.consume((HttpEntity)entity);
            }
        }
        return result.toString();
    }
}

