package com.jz.website.repository;

import java.util.List;

import org.jooq.Condition;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Repository;

import com.jz.common.utils.collection.ArrayMapTools;
import com.jz.jooq.website.Tables;
import com.jz.jooq.website.tables.pojos.ActivityInfo;

@Lazy
@Repository
public class ActivityRepository extends WebsiteBaseRepository {

	private static final com.jz.jooq.website.tables.ActivityInfo AI = Tables.ACTIVITY_INFO;
	private static final com.jz.jooq.website.tables.ActivitySchool AS = Tables.ACTIVITY_SCHOOL;

	private Condition getCondition(String school, long timeMillis) {
		// 0未发布 1已发布 2取消发布 -1删除
		return AS.SCHOOL_ID.eq(school).and(AS.START_TIME.le(timeMillis)).and(AS.STATUS.eq(1));
	}

	public int cntActivity(String school, long timeMillis) {
		return websiteCtx.fetchCount(AS, getCondition(school, timeMillis));
	}

	public List<String> getActivityId(String school, long timeMillis, int start, int size) {
		return websiteCtx.select(AS.ACTIVITY_ID).from(AS).where(getCondition(school, timeMillis))
				.orderBy(AS.START_TIME.desc()).limit(start, size).fetchInto(String.class);
	}

	public List<ActivityInfo> getListActivityInfo(List<String> activityIds) {
		return websiteCtx.select(AI.ACTIVITY_ID, AI.TITLE, AI.PIC, AI.END_TIME).from(AI)
				.where(AI.ACTIVITY_ID.in(activityIds)).orderBy(AI.START_TIME.desc()).fetchInto(ActivityInfo.class);
	}

	public ActivityInfo getActivityInfo(String activityId) {
		return ArrayMapTools
				.getFirst(websiteCtx.selectFrom(AI).where(AI.ACTIVITY_ID.eq(activityId)).fetchInto(ActivityInfo.class));
	}

	public List<ActivityInfo> getBannerActivityInfo(List<String> activityIds) {
		return websiteCtx.select(AI.ACTIVITY_ID, AI.TITLE, AI.BANNER_PIC).from(AI).where(AI.ACTIVITY_ID.in(activityIds))
				.fetchInto(ActivityInfo.class);
	}
}
