/*
 * Decompiled with CFR 0.152.
 */
package com.jz.website.repository;

import com.jz.common.utils.collection.ArrayMapTools;
import com.jz.jooq.website.Tables;
import com.jz.jooq.website.tables.ActivitySchool;
import com.jz.jooq.website.tables.pojos.ActivityInfo;
import com.jz.website.repository.WebsiteBaseRepository;
import java.util.Collection;
import java.util.List;
import org.jooq.Condition;
import org.jooq.SelectField;
import org.jooq.Table;
import org.jooq.TableLike;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Repository;

@Lazy
@Repository
public class ActivityRepository
extends WebsiteBaseRepository {
    private static final com.jz.jooq.website.tables.ActivityInfo AI = Tables.ACTIVITY_INFO;
    private static final ActivitySchool AS = Tables.ACTIVITY_SCHOOL;

    private Condition getCondition(String school, long timeMillis) {
        return ActivityRepository.AS.SCHOOL_ID.eq((Object)school).and(ActivityRepository.AS.START_TIME.le((Object)timeMillis)).and(ActivityRepository.AS.STATUS.eq((Object)1));
    }

    public int cntActivity(String school, long timeMillis) {
        return this.websiteCtx.fetchCount((Table)AS, this.getCondition(school, timeMillis));
    }

    public List<String> getActivityId(String school, long timeMillis, int start, int size) {
        return this.websiteCtx.select((SelectField)ActivityRepository.AS.ACTIVITY_ID).from((TableLike)AS).where(new Condition[]{this.getCondition(school, timeMillis)}).orderBy(ActivityRepository.AS.START_TIME.desc()).limit(start, size).fetchInto(String.class);
    }

    public List<ActivityInfo> getListActivityInfo(List<String> activityIds) {
        return this.websiteCtx.select((SelectField)ActivityRepository.AI.ACTIVITY_ID, (SelectField)ActivityRepository.AI.TITLE, (SelectField)ActivityRepository.AI.PIC, (SelectField)ActivityRepository.AI.END_TIME).from((TableLike)AI).where(new Condition[]{ActivityRepository.AI.ACTIVITY_ID.in(activityIds)}).orderBy(ActivityRepository.AI.START_TIME.desc()).fetchInto(ActivityInfo.class);
    }

    public ActivityInfo getActivityInfo(String activityId) {
        return (ActivityInfo)ArrayMapTools.getFirst((Collection)this.websiteCtx.selectFrom((Table)AI).where(new Condition[]{ActivityRepository.AI.ACTIVITY_ID.eq((Object)activityId)}).fetchInto(ActivityInfo.class));
    }

    public List<ActivityInfo> getBannerActivityInfo(List<String> activityIds) {
        return this.websiteCtx.select((SelectField)ActivityRepository.AI.ACTIVITY_ID, (SelectField)ActivityRepository.AI.TITLE, (SelectField)ActivityRepository.AI.BANNER_PIC).from((TableLike)AI).where(new Condition[]{ActivityRepository.AI.ACTIVITY_ID.in(activityIds)}).fetchInto(ActivityInfo.class);
    }
}

