package com.jz.website.repository;

import java.util.List;

import org.jooq.Condition;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Repository;

import com.jz.common.utils.collection.ArrayMapTools;
import com.jz.jooq.website.Tables;
import com.jz.jooq.website.tables.pojos.Art;

@Lazy
@Repository
public class ArtRepository extends WebsiteBaseRepository {

	private static final com.jz.jooq.website.tables.Art ART = Tables.ART;
	private static final com.jz.jooq.website.tables.ArtSchool AS = Tables.ART_SCHOOL;

	private Condition getCondition(String school) {
		return AS.SCHOOL_ID.eq(school).and(AS.STATUS.eq(1));
	}

	public int cntArt(String school) {
		return websiteCtx.fetchCount(AS, getCondition(school));
	}

	public List<String> getArtId(String school, int start, int size) {
		// 0未发布 1已发布 2取消发布 -1删除
		return websiteCtx.select(AS.AID).from(AS).where(getCondition(school)).orderBy(AS.CREATE_TIME.desc())
				.limit(start, size).fetchInto(String.class);
	}

	public List<Art> getListArtInfo(List<String> aids) {
		return websiteCtx.select(ART.ID, ART.TITLE, ART.PIC, ART.VIDEO_URL, ART.BABY_NAME, ART.BABY_AGE).from(ART)
				.where(ART.ID.in(aids)).orderBy(ART.CREATE_TIME.desc()).fetchInto(Art.class);
	}

	public Art getArtInfo(String aid) {
		return ArrayMapTools.getFirst(websiteCtx.selectFrom(ART).where(ART.ID.eq(aid)).fetchInto(Art.class));
	}

	public List<Art> getBannerArtInfo(List<String> aids) {
		return websiteCtx.select(ART.ID, ART.TITLE, ART.BANNER_PIC).from(ART).where(ART.ID.in(aids))
				.fetchInto(Art.class);
	}
}
